/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.aplication.useCase.account.balance.GetBalanceUseCase;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IItemStack;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.PaginatedPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public class AccountBalance
extends PaginatedPanel<Money> {
    private final GetBalanceUseCase getBalanceUseCase;
    private final UUID targetUUID;

    public AccountBalance(IEntityGUI player, GetBalanceUseCase getBalanceUseCase, IGUI parent) {
        super(Message.process("AccountBalance.title"), 3, player, parent, 7);
        this.getBalanceUseCase = getBalanceUseCase;
        this.targetUUID = player.getUniqueId();
        this.loadBalances();
    }

    public AccountBalance(IEntityGUI sender, UUID target, GetBalanceUseCase getBalanceUseCase, IGUI parent) {
        super(Message.process("AccountBalance.title"), 3, sender, parent, 7);
        this.getBalanceUseCase = getBalanceUseCase;
        this.targetUUID = target;
        this.loadBalances();
    }

    private void loadBalances() {
        Result<List<Money>> result = this.getBalanceUseCase.getBalances(this.targetUUID);
        if (result.isSuccess() && result.getValue() != null) {
            this.showItemsPage(result.getValue());
        } else {
            this.showItemsPage(new ArrayList());
        }
    }

    @Override
    protected IItemStack createItemFor(Money money) {
        Currency currency = money.getCurrency();
        return this.createItem(Materials.GOLD_INGOT, Message.process(Map.of("currency", ChatColor.stringValueOf(currency.getColor()) + currency.getSingular()), "AccountBalance.button1.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE), "currency", ChatColor.stringValueOf(currency.getColor()) + money.format()), "AccountBalance.button1.lore"));
    }

    @Override
    protected IItemStack createEmptyMessage() {
        return this.createItem(Materials.BARRIER, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.RED)), "AccountBalance.button2.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "AccountBalance.button2.lore"));
    }

    @Override
    protected void addCustomButtons() {
        this.setItem(4, this.createItem(Materials.BOOK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "AccountBalance.button3.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "AccountBalance.button3.lore")), null);
    }
}

