/*
 * Decompiled with CFR 0.152.
 */
package lib.util.colors;

import lib.util.colors.Colors;

public class Color {
    private Colors color;
    private String stringColor;

    private Color(Colors color) {
        this.color = color;
    }

    private Color(String color) {
        this.stringColor = color;
    }

    public static Color of(Colors color) {
        return new Color(color);
    }

    public static Color of(String color) {
        return new Color(color);
    }

    public String formatToMinimessage() {
        return "<" + this.getHexadecimal() + ">";
    }

    public String getHexadecimal() {
        if (this.color != null) {
            this.stringColor = this.color.name();
        }
        switch (this.stringColor.toUpperCase()) {
            case "BLACK": {
                return "#000000";
            }
            case "DARK_BLUE": {
                return "#0000AA";
            }
            case "DARK_GREEN": {
                return "#00AA00";
            }
            case "DARK_AQUA": {
                return "#00AAAA";
            }
            case "DARK_RED": {
                return "#AA0000";
            }
            case "DARK_PURPLE": {
                return "#AA00AA";
            }
            case "GOLD": {
                return "#FFAA00";
            }
            case "GRAY": {
                return "#C4C4C4";
            }
            case "DARK_GRAY": {
                return "#555555";
            }
            case "BLUE": {
                return "#5555FF";
            }
            case "GREEN": {
                return "#55FF55";
            }
            case "AQUA": {
                return "#55FFFF";
            }
            case "RED": {
                return "#FF5555";
            }
            case "LIGHT_PURPLE": {
                return "#FF55FF";
            }
            case "YELLOW": {
                return "#FFFF55";
            }
            case "WHITE": {
                return "#FFFFFF";
            }
        }
        return this.stringColor;
    }

    public String getVanillaFormat() {
        if (this.color != null) {
            this.stringColor = this.color.name();
        }
        if (this.stringColor.startsWith("#")) {
            return "\u00a7f";
        }
        switch (this.stringColor.toUpperCase()) {
            case "BLACK": {
                return "\u00a70";
            }
            case "DARK_BLUE": {
                return "\u00a71";
            }
            case "DARK_GREEN": {
                return "\u00a72";
            }
            case "DARK_AQUA": {
                return "\u00a73";
            }
            case "DARK_RED": {
                return "\u00a74";
            }
            case "DARK_PURPLE": {
                return "\u00a75";
            }
            case "GOLD": {
                return "\u00a76";
            }
            case "GRAY": {
                return "\u00a77";
            }
            case "DARK_GRAY": {
                return "\u00a78";
            }
            case "BLUE": {
                return "\u00a79";
            }
            case "GREEN": {
                return "\u00a7a";
            }
            case "AQUA": {
                return "\u00a7b";
            }
            case "RED": {
                return "\u00a7c";
            }
            case "LIGHT_PURPLE": {
                return "\u00a7d";
            }
            case "YELLOW": {
                return "\u00a7e";
            }
            case "WHITE": {
                return "\u00a7f";
            }
        }
        return this.stringColor;
    }
}

