/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;

@Internal
public final class HCANNHelper {
    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationToCheck) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck);
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationToCheck, Class<? extends Annotation> annotationToCheck2) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck) || element.isAnnotationPresent(annotationToCheck2);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> annotationToCheck) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> annotationToCheck, Class<? extends Annotation> annotationToCheck2) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck) || element.isAnnotationPresent(annotationToCheck2);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> ... annotationsToCheck) {
        assert (annotationsToCheck != null && annotationsToCheck.length > 0);
        if (element == null) {
            return false;
        }
        for (int i = 0; i < annotationsToCheck.length; ++i) {
            if (!element.isAnnotationPresent(annotationsToCheck[i])) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String annotatedElementSignature(XProperty property) {
        return HCANNHelper.getUnderlyingMember(property).toString();
    }

    public static String annotatedElementSignature(JavaXMember member) {
        return HCANNHelper.getUnderlyingMember(member).toString();
    }

    @Deprecated
    public static Member getUnderlyingMember(XProperty property) {
        if (property instanceof JavaXMember) {
            JavaXMember member = (JavaXMember)((Object)property);
            return member.getMember();
        }
        throw new HibernateException("Can only extract Member from a XProperty which is a JavaXMember");
    }

    public static Member getUnderlyingMember(JavaXMember member) {
        return member.getMember();
    }

    public static <T extends Annotation> T findAnnotation(XAnnotatedElement annotatedElement, Class<T> annotationType) {
        Annotation[] annotations;
        T direct = annotatedElement.getAnnotation(annotationType);
        if (direct != null) {
            return direct;
        }
        for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
            T metaAnnotation;
            if (annotationType.equals(annotation.getClass()) || (metaAnnotation = annotation.annotationType().getAnnotation(annotationType)) == null) continue;
            return metaAnnotation;
        }
        return null;
    }

    public static List<Annotation> findContainingAnnotations(XAnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        Annotation[] annotations;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
            Annotation metaAnn = annotation.annotationType().getAnnotation(annotationType);
            if (metaAnn == null) continue;
            result.add(annotation);
        }
        return result;
    }
}

