/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class AltibaseSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public AltibaseSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("row_number() over(order by 1)");
            return;
        }
        super.visitOver(over);
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        if (tableGroupJoin.getJoinType() != SqlAstJoinType.CROSS) {
            this.appendSql(tableGroupJoin.getJoinType().getText());
        }
        this.appendSql("join ");
        Predicate predicate = tableGroupJoin.getPredicate() == null ? new BooleanExpressionPredicate(new QueryLiteral<Boolean>(true, this.getBooleanType())) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected void renderOffsetExpression(Expression offsetExpression) {
        this.appendSql("1+");
        offsetExpression.accept(this);
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    @Override
    protected void renderMergeUpdateClause(List<Assignment> assignments, Predicate wherePredicate) {
        this.appendSql(" then update");
        this.renderSetClause(assignments);
        this.visitWhereClause(wherePredicate);
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReferenceIdentificationVariable(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("floor");
        }
        super.visitBinaryArithmeticExpression(arithmeticExpression);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsJoinsInDelete() {
        return true;
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return false;
    }
}

