/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.InformixSqlAstTranslator;
import org.hibernate.community.dialect.InformixSqmToSqlAstConverter;
import org.hibernate.community.dialect.identity.InformixIdentityColumnSupport;
import org.hibernate.community.dialect.pagination.FirstLimitHandler;
import org.hibernate.community.dialect.pagination.SkipFirstLimitHandler;
import org.hibernate.community.dialect.sequence.InformixSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorInformixDatabaseImpl;
import org.hibernate.community.dialect.unique.InformixUniqueDelegate;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.VarcharUUIDJdbcType;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class InformixDialect
extends Dialect {
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make(7, 0);
    private final UniqueDelegate uniqueDelegate;
    private final LimitHandler limitHandler;
    private final SequenceSupport sequenceSupport;
    private final StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this){

        @Override
        public String[] getSqlCreateStrings(ForeignKey foreignKey, Metadata metadata, SqlStringGenerationContext context) {
            String[] results = super.getSqlCreateStrings(foreignKey, metadata, context);
            for (int i = 0; i < results.length; ++i) {
                Object result = results[i];
                if (!((String)result).contains(" on delete ")) continue;
                String constraintName = "constraint " + foreignKey.getName();
                result = ((String)result).replace(constraintName + " ", "");
                results[i] = result = (String)result + " " + constraintName;
            }
            return results;
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName;
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case -268: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Unique constraint (", ") violated.", sqle.getMessage());
                break;
            }
            case -691: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Missing key in referenced table for referential constraint (", ").", sqle.getMessage());
                break;
            }
            case -692: {
                constraintName = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Key value for constraint (", ") is still being referenced.", sqle.getMessage());
                break;
            }
            default: {
                return null;
            }
        }
        int i = constraintName.indexOf(46);
        if (i != -1) {
            constraintName = constraintName.substring(i + 1);
        }
        return constraintName;
    });

    public InformixDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public InformixDialect() {
        this(DEFAULT_VERSION);
    }

    public InformixDialect(DatabaseVersion version) {
        super(version);
        this.uniqueDelegate = new InformixUniqueDelegate(this);
        this.limitHandler = this.getVersion().isBefore(10) ? FirstLimitHandler.INSTANCE : new SkipFirstLimitHandler(this.getVersion().isSameOrAfter(11));
        this.sequenceSupport = new InformixSequenceSupport(this.getVersion().isSameOrAfter(11, 70));
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -5: {
                return "int8";
            }
            case 92: {
                return "datetime hour to second";
            }
            case 93: 
            case 2014: {
                return "datetime year to fraction($p)";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "byte";
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case -9: 
            case 12: {
                return "lvarchar($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(6, "float", this).withTypeCapacity(8L, "smallfloat").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(12, this.columnType(4001), "varchar(255)", (Dialect)this).withTypeCapacity(255L, "varchar($l)").withTypeCapacity(this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-9, this.columnType(4002), "nvarchar(255)", (Dialect)this).withTypeCapacity(255L, "nvarchar($l)").withTypeCapacity(this.getMaxNVarcharLength(), this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "char(36)", this));
    }

    @Override
    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return -1;
    }

    @Override
    public int getMaxVarcharLength() {
        return 32739;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 32;
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 5;
    }

    @Override
    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    public int getFloatPrecision() {
        return 8;
    }

    @Override
    public int getDoublePrecision() {
        return 16;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.trunc();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.reverse();
        functionFactory.octetLength();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cosh();
        functionFactory.moreHyperbolic();
        functionFactory.log10();
        functionFactory.initcap();
        functionFactory.yearMonthDay();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.locate_positionSubstring();
        functionContributions.getFunctionRegistry().register("least", new CaseLeastGreatestEmulation(true));
        functionContributions.getFunctionRegistry().register("greatest", new CaseLeastGreatestEmulation(false));
        if (this.supportsWindowFunctions()) {
            functionFactory.windowFunctions();
        }
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            @Override
            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new InformixSqmToSqlAstConverter<SelectStatement>(sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new InformixSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "to_number(to_char(?2,'%S'))";
            }
            case MINUTE: {
                return "to_number(to_char(?2,'%M'))";
            }
            case HOUR: {
                return "to_number(to_char(?2,'%H'))";
            }
            case DAY_OF_WEEK: {
                return "(weekday(?2)+1)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder result = new StringBuilder(30).append(" add constraint ").append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            result.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        result.append(" constraint ").append(constraintName);
        return result.toString();
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + foreignKeyDefinition + " constraint " + constraintName;
    }

    @Override
    public Exporter<ForeignKey> getForeignKeyExporter() {
        if (this.getVersion().isSameOrAfter(12, 10)) {
            return super.getForeignKeyExporter();
        }
        return this.foreignKeyExporter;
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint primary key constraint " + constraintName + " ";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.sequenceSupport;
    }

    @Override
    public String getQuerySequencesString() {
        return "select systables.tabname as sequence_name,syssequences.* from syssequences join systables on syssequences.tabid=systables.tabid where tabtype='Q'";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorInformixDatabaseImpl.INSTANCE;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    @Override
    public boolean supportsIfExistsBeforeTypeName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(11, 70);
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(12, 10);
    }

    @Override
    public boolean supportsValuesListForInsert() {
        return false;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select distinct current timestamp from informix.systables";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "with no log";
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create temp table";
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.NONE;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema authorization " + schemaName};
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{""};
    }

    @Override
    public boolean useCrossReferenceForeignKeys() {
        return true;
    }

    @Override
    public String getCrossReferenceParentTableFilter() {
        return "%";
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return InformixIdentityColumnSupport.INSTANCE;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool ? "'t'" : "'f'");
    }

    @Override
    public String currentDate() {
        return "today";
    }

    @Override
    public String currentTimestamp() {
        return "current";
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(InformixDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "Y").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("EEEE", "%A").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%I").replace("H", "%H").replace("mm", "%M").replace("m", "%M").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%F50").replace("SSSSS", "%F5").replace("SSSS", "%F4").replace("SSS", "%F3").replace("SS", "%F2").replace("S", "%F1");
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        DdlType descriptor = typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType);
        if (descriptor == null) {
            return "null";
        }
        String typeName = descriptor.getTypeName(Size.length(255L));
        int loc = typeName.indexOf(40);
        if (loc > -1) {
            typeName = typeName.substring(0, loc);
        }
        return "null::" + typeName;
    }

    @Override
    public String getNoColumnsInsertString() {
        return "values (0)";
    }

    @Override
    public boolean supportsNationalizedMethods() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2011, ClobJdbcType.DEFAULT);
        typeContributions.contributeJdbcType(VarcharUUIDJdbcType.INSTANCE);
    }

    @Override
    public String getDual() {
        return "(select 0 from systables where tabid=1)";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual() + " dual";
    }
}

