/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.SessionFactory;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultRefreshEventListener.class);

    @Override
    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, RefreshContext.create());
    }

    @Override
    public void onRefresh(RefreshEvent event, RefreshContext refreshedAlready) {
        Object object;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        if (persistenceContext.reassociateIfUninitializedProxy(object = event.getObject())) {
            boolean isTransient = DefaultRefreshEventListener.isTransient(event, source, object);
            if (refreshedAlready.isEmpty()) {
                EntityPersister persister;
                LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
                if (lazyInitializer != null) {
                    persister = source.getEntityPersister(lazyInitializer.getEntityName(), object);
                } else if (!isTransient) {
                    EntityEntry entry = persistenceContext.getEntry(object);
                    persister = entry.getPersister();
                } else {
                    persister = source.getEntityPersister(source.guessEntityName(object), object);
                }
                DefaultRefreshEventListener.refresh(event, null, source, persister, lazyInitializer, null, persister.getIdentifier(object, event.getSession()), persistenceContext);
                if (lazyInitializer != null) {
                    refreshedAlready.add(lazyInitializer.getImplementation());
                }
            }
            if (isTransient) {
                source.setReadOnly(object, source.isDefaultReadOnly());
            }
        } else {
            Object entity = persistenceContext.unproxyAndReassociate(object);
            if (refreshedAlready.add(entity)) {
                DefaultRefreshEventListener.refresh(event, refreshedAlready, entity);
            } else {
                LOG.trace("Already refreshed");
            }
        }
    }

    private static boolean isTransient(RefreshEvent event, EventSource source, Object object) {
        String entityName = event.getEntityName();
        return entityName != null ? !source.contains(entityName, object) : !source.contains(object);
    }

    private static void refresh(RefreshEvent event, RefreshContext refreshedAlready, Object object) {
        Object id;
        EntityPersister persister;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(object);
        if (entry == null) {
            persister = source.getEntityPersister(event.getEntityName(), object);
            id = persister.getIdentifier(object, event.getSession());
            if (id == null) {
                throw new TransientObjectException("transient instance passed to refresh");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", (Object)MessageHelper.infoString(persister, id, event.getFactory()));
            }
            if (persistenceContext.getEntry(source.generateEntityKey(id, persister)) != null) {
                throw new NonUniqueObjectException(id, persister.getEntityName());
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", (Object)MessageHelper.infoString(entry.getPersister(), entry.getId(), event.getFactory()));
            }
            if (!entry.isExistsInDatabase()) {
                throw new UnresolvableObjectException(entry.getId(), "this instance does not yet exist as a row in the database");
            }
            persister = entry.getPersister();
            id = entry.getId();
        }
        Cascade.cascade(CascadingActions.REFRESH, CascadePoint.BEFORE_REFRESH, source, persister, object, refreshedAlready);
        if (entry != null) {
            persistenceContext.removeEntityHolder(entry.getEntityKey());
            if (persister.hasCollections()) {
                new EvictVisitor(source, object).process(object, persister);
            }
            persistenceContext.removeEntry(object);
        }
        DefaultRefreshEventListener.evictEntity(object, persister, id, source);
        DefaultRefreshEventListener.evictCachedCollections(persister, id, source);
        DefaultRefreshEventListener.refresh(event, object, source, persister, null, entry, id, persistenceContext);
    }

    private static void refresh(RefreshEvent event, Object object, EventSource source, EntityPersister persister, LazyInitializer lazyInitializer, EntityEntry entry, Object id, PersistenceContext persistenceContext) {
        Object result = source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.REFRESH, () -> DefaultRefreshEventListener.doRefresh(event, source, object, entry, persister, lazyInitializer, id, persistenceContext));
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    private static void evictEntity(Object object, EntityPersister persister, Object id, EventSource source) {
        if (persister.canWriteToCache()) {
            Object previousVersion = null;
            if (persister.isVersionPropertyGenerated()) {
                previousVersion = persister.getVersion(object);
            }
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, (SessionFactoryImplementor)source.getFactory(), source.getTenantIdentifier());
            SoftLock lock = cache.lockItem(source, ck, previousVersion);
            cache.remove(source, ck);
            source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
        }
    }

    private static Object doRefresh(RefreshEvent event, EventSource source, Object object, EntityEntry entry, EntityPersister persister, LazyInitializer lazyInitializer, Object id, PersistenceContext persistenceContext) {
        LockMode postRefreshLockMode;
        LockOptions lockOptionsToUse = event.getLockOptions();
        LockMode requestedLockMode = lockOptionsToUse.getLockMode();
        if (entry != null) {
            LockMode currentLockMode = entry.getLockMode();
            if (currentLockMode.greaterThan(requestedLockMode)) {
                lockOptionsToUse = event.getLockOptions().makeCopy();
                if (currentLockMode == LockMode.WRITE || currentLockMode == LockMode.PESSIMISTIC_WRITE || currentLockMode == LockMode.PESSIMISTIC_READ) {
                    lockOptionsToUse.setLockMode(LockMode.READ);
                    postRefreshLockMode = currentLockMode;
                } else {
                    lockOptionsToUse.setLockMode(currentLockMode);
                    postRefreshLockMode = null;
                }
            } else {
                postRefreshLockMode = null;
            }
        } else {
            postRefreshLockMode = null;
        }
        Object result = persister.load(id, object, lockOptionsToUse, (SharedSessionContractImplementor)source);
        if (result != null) {
            if (postRefreshLockMode != null) {
                persistenceContext.getEntry(result).setLockMode(postRefreshLockMode);
            }
            source.setReadOnly(result, DefaultRefreshEventListener.isReadOnly(entry, persister, lazyInitializer, source));
        }
        return result;
    }

    private static boolean isReadOnly(EntityEntry entry, EntityPersister persister, LazyInitializer lazyInitializer, EventSource source) {
        if (!persister.isMutable()) {
            return true;
        }
        if (entry != null) {
            return entry.isReadOnly();
        }
        if (lazyInitializer != null) {
            return lazyInitializer.isReadOnly();
        }
        return source.isDefaultReadOnly();
    }

    private static void evictCachedCollections(EntityPersister persister, Object id, EventSource source) {
        DefaultRefreshEventListener.evictCachedCollections(persister.getPropertyTypes(), id, source);
    }

    private static void evictCachedCollections(Type[] types, Object id, EventSource source) throws HibernateException {
        ActionQueue actionQueue = source.getActionQueue();
        SessionFactory factory = source.getFactory();
        MappingMetamodelImplementor metamodel = factory.getRuntimeMetamodels().getMappingMetamodel();
        for (Type type : types) {
            if (type instanceof CollectionType) {
                String role = ((CollectionType)type).getRole();
                CollectionPersister collectionPersister = metamodel.getCollectionDescriptor(role);
                if (!collectionPersister.hasCache()) continue;
                CollectionDataAccess cache = collectionPersister.getCacheAccessStrategy();
                Object ck = cache.generateCacheKey(id, collectionPersister, (SessionFactoryImplementor)factory, source.getTenantIdentifier());
                SoftLock lock = cache.lockItem(source, ck, null);
                cache.remove(source, ck);
                actionQueue.registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
                continue;
            }
            if (!(type instanceof ComponentType)) continue;
            ComponentType compositeType = (ComponentType)type;
            DefaultRefreshEventListener.evictCachedCollections(compositeType.getSubtypes(), id, source);
        }
    }
}

