/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentitySet<E>
implements Set<E> {
    private static final Object DUMP_VALUE = new Object();
    private final IdentityHashMap<E, Object> map;

    public IdentitySet() {
        this.map = new IdentityHashMap();
    }

    public IdentitySet(int sizing) {
        this.map = new IdentityHashMap(sizing);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.get(o) == DUMP_VALUE;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.map.keySet().toArray(a2);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, DUMP_VALUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == DUMP_VALUE;
    }

    @Override
    public boolean containsAll(Collection<?> checkValues) {
        for (Object checkValue : checkValues) {
            if (this.map.containsKey(checkValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> additions) {
        boolean changed = false;
        for (E addition : additions) {
            changed = this.add(addition) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> keepers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> removals) {
        boolean changed = false;
        for (Object removal : removals) {
            changed = this.remove(removal) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

