/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import com.BlockDynasty.antlr.v4.runtime.tree.ParseTree;
import com.BlockDynasty.antlr.v4.runtime.tree.TerminalNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.grammars.importsql.SqlScriptParser;
import org.hibernate.grammars.importsql.SqlScriptParserBaseVisitor;

public class SqlScriptVisitor
extends SqlScriptParserBaseVisitor<Object> {
    private final Dialect dialect;

    public SqlScriptVisitor(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public List<String> visitScript(SqlScriptParser.ScriptContext ctx) {
        List children = ctx.children;
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<String> commands = new ArrayList<String>(children.size());
        StringBuilder commandBuffer = new StringBuilder();
        for (int i = 0; i < children.size(); ++i) {
            ParseTree parseTree = (ParseTree)children.get(i);
            if (!(parseTree instanceof SqlScriptParser.CommandBlockContext)) continue;
            commandBuffer.setLength(0);
            SqlScriptParser.CommandBlockContext blockContext = (SqlScriptParser.CommandBlockContext)parseTree;
            List terminalNodes = blockContext.command().children;
            block6: for (int j = 0; j < terminalNodes.size(); ++j) {
                TerminalNode terminalNode = (TerminalNode)terminalNodes.get(j);
                switch (terminalNode.getSymbol().getType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        commandBuffer.append(terminalNode.getText());
                        continue block6;
                    }
                    case 8: {
                        commandBuffer.append(this.dialect.quote(terminalNode.getText()));
                        continue block6;
                    }
                    case 6: {
                        commandBuffer.append(' ');
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported token: " + terminalNode);
                    }
                }
            }
            commands.add(commandBuffer.toString());
        }
        return commands;
    }
}

