/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.account;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.courier.Courier;
import java.util.UUID;

public class EditAccountUseCase {
    private final IRepository dataStore;
    private final SearchAccountUseCase searchAccountUseCase;
    private final Courier courier;

    public EditAccountUseCase(SearchAccountUseCase searchAccountUseCase, IRepository dataStore, Courier courier) {
        this.dataStore = dataStore;
        this.searchAccountUseCase = searchAccountUseCase;
        this.courier = courier;
    }

    public Result<Void> blockReceive(UUID uuid) {
        Result<Account> result = this.searchAccountUseCase.getAccount(uuid);
        if (!result.isSuccess()) {
            return Result.failure("Account not found", result.getErrorCode());
        }
        result.getValue().setCanReceiveCurrency(false);
        this.dataStore.saveAccount(result.getValue());
        this.courier.sendUpdateMessage("account", uuid.toString());
        return Result.success();
    }

    public Result<Void> allowReceive(UUID uuid) {
        Result<Account> result = this.searchAccountUseCase.getAccount(uuid);
        if (!result.isSuccess()) {
            return Result.failure("Account not found", result.getErrorCode());
        }
        result.getValue().setCanReceiveCurrency(true);
        this.dataStore.saveAccount(result.getValue());
        this.courier.sendUpdateMessage("account", uuid.toString());
        return Result.success();
    }

    public Result<Void> blockAccount(UUID uuid) {
        Result<Account> result = this.searchAccountUseCase.getAccount(uuid);
        if (!result.isSuccess()) {
            return Result.failure("Account not found", result.getErrorCode());
        }
        result.getValue().block();
        this.dataStore.saveAccount(result.getValue());
        this.courier.sendUpdateMessage("account", uuid.toString());
        return Result.success();
    }

    public Result<Void> unblockAccount(UUID uuid) {
        Result<Account> result = this.searchAccountUseCase.getAccount(uuid);
        if (!result.isSuccess()) {
            return Result.failure("Account not found", result.getErrorCode());
        }
        result.getValue().unblock();
        this.dataStore.saveAccount(result.getValue());
        this.courier.sendUpdateMessage("account", uuid.toString());
        return Result.success();
    }
}

