/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.currency;

import BlockDynasty.Economy.domain.entities.currency.ICurrency;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.UUID;

public class Currency
implements ICurrency {
    private String uuid;
    private String singular;
    private String plural;
    private String symbol;
    private String color;
    private boolean decimalSupported;
    private boolean transferable;
    private boolean defaultCurrency;
    private BigDecimal defaultBalance;
    private double exchangeRate;

    public Currency(UUID uuid, String singular, String plural) {
        this.defaultBalance = BigDecimal.ZERO;
        this.exchangeRate = 1.0;
        this.color = "WHITE";
        this.symbol = "";
        this.decimalSupported = true;
        this.transferable = true;
        this.defaultCurrency = false;
        this.uuid = uuid.toString();
        this.singular = singular;
        this.plural = plural;
    }

    public Currency() {
        this.defaultBalance = BigDecimal.ZERO;
        this.exchangeRate = 1.0;
        this.color = "WHITE";
        this.symbol = "";
        this.decimalSupported = true;
        this.transferable = true;
        this.defaultCurrency = false;
    }

    public Currency(UUID uuid, String singular, String plural, String symbol, String color, boolean decimalSupported, boolean transferable, boolean defaultCurrency, BigDecimal defaultBalance, double exchangeRate) {
        this.uuid = uuid.toString();
        this.singular = singular;
        this.plural = plural;
        this.symbol = symbol;
        this.color = color;
        this.decimalSupported = decimalSupported;
        this.transferable = transferable;
        this.defaultCurrency = defaultCurrency;
        this.defaultBalance = defaultBalance;
        this.exchangeRate = exchangeRate;
    }

    public Currency(Currency currency) {
        this.uuid = currency.uuid;
        this.singular = currency.singular;
        this.plural = currency.plural;
        this.symbol = currency.symbol;
        this.color = currency.color;
        this.decimalSupported = currency.decimalSupported;
        this.transferable = currency.transferable;
        this.defaultCurrency = currency.defaultCurrency;
        this.defaultBalance = currency.defaultBalance;
        this.exchangeRate = currency.exchangeRate;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid.toString();
    }

    @Override
    public void setSingular(String singular) {
        this.singular = singular;
    }

    @Override
    public void setPlural(String plural) {
        this.plural = plural;
    }

    @Override
    public UUID getUuid() {
        return UUID.fromString(this.uuid);
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public BigDecimal getDefaultBalance() {
        return this.defaultBalance;
    }

    @Override
    public String format(BigDecimal amount) {
        StringBuilder amt = new StringBuilder();
        if (this.isDecimalSupported()) {
            amount = amount.setScale(2, RoundingMode.HALF_UP);
            amt.append(NumberFormat.getInstance().format(amount));
        } else {
            String s = amount.setScale(0, RoundingMode.HALF_UP).toPlainString();
            amt.append(NumberFormat.getInstance().format(Double.parseDouble(s)));
        }
        amt.append(" ");
        if (!this.getSymbol().isEmpty()) {
            amt.append(this.getSymbol());
        } else if (amount.compareTo(BigDecimal.ONE) != 0) {
            amt.append(this.getPlural().replace("_", " "));
        } else {
            amt.append(this.getSingular().replace("_", " "));
        }
        return amt.toString();
    }

    @Override
    public boolean isValidAmount(BigDecimal amount) {
        return this.isDecimalSupported() || amount.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean isDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Override
    public void setStartBalance(BigDecimal startBalance) {
        this.defaultBalance = startBalance;
    }

    @Override
    public void setDefaultBalance(BigDecimal defaultBalance) {
        this.defaultBalance = defaultBalance;
    }

    @Override
    public void setDefaultCurrency(boolean defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Override
    public boolean isTransferable() {
        return this.transferable;
    }

    @Override
    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    @Override
    public boolean isDecimalSupported() {
        return this.decimalSupported;
    }

    @Override
    public void setDecimalSupported(boolean decimalSupported) {
        this.decimalSupported = decimalSupported;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public double getExchangeRate() {
        return this.exchangeRate;
    }

    @Override
    public void setExchangeRate(double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String toString() {
        return "Currency{uuid='" + this.uuid + "', singular='" + this.singular + "', plural='" + this.plural + "', symbol='" + this.symbol + "', color='" + this.color + "', decimalSupported=" + this.decimalSupported + ", transferable=" + this.transferable + ", defaultCurrency=" + this.defaultCurrency + ", defaultBalance=" + String.valueOf(this.defaultBalance) + ", exchangeRate=" + this.exchangeRate + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Currency currency = (Currency)o;
        return this.uuid.equals(currency.uuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

