/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty;

import BlockDynasty.adapters.GUI.adapters.TextInput;
import BlockDynasty.adapters.commands.CommandRegister;
import BlockDynasty.adapters.integrations.spongeEconomyApi.EconomyServiceAdapter;
import BlockDynasty.adapters.integrations.spongeEconomyApi.MultiCurrencyService;
import BlockDynasty.adapters.listeners.PlayerJoinListenerOffline;
import BlockDynasty.adapters.listeners.PlayerJoinListenerOnline;
import BlockDynasty.adapters.platformAdapter.SpongeAdapter;
import BlockDynasty.adapters.proxy.ProxyReceiverImp;
import BlockDynasty.utils.Console;
import Main.Economy;
import com.BlockDynasty.bstats.sponge.Metrics;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import lib.commands.CommandsFactory;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.ConstructPluginEvent;
import org.spongepowered.api.event.lifecycle.ProvideServiceEvent;
import org.spongepowered.api.event.lifecycle.RegisterChannelEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;
import platform.files.Configuration;
import platform.proxy.ProxyData;

@Plugin(value="blockdynastyeconomy")
public class SpongePlugin {
    private static PluginContainer container;
    private static Logger logger;
    private static Economy economy;
    private static Configuration configuration;
    public static Path configPath;
    private static RawDataChannel channel;
    private final Metrics metrics;

    @Inject
    public SpongePlugin(PluginContainer container, Logger logger2, @ConfigDir(sharedRoot=false) Path configDir, Metrics.Factory metricsFactory) {
        SpongePlugin.container = container;
        logger = logger2;
        configPath = configDir;
        this.metrics = metricsFactory.make(27472);
    }

    @Listener
    public void onRegisterChannel(RegisterChannelEvent event) {
        channel = (RawDataChannel)event.register(ResourceKey.resolve((String)ProxyData.getChannelName()), RawDataChannel.class);
        ProxyReceiverImp.register().addHandler(channel);
    }

    @Listener
    public void onConstructPlugin(ConstructPluginEvent event) {
        economy = Economy.init(new TextInput(), new SpongeAdapter());
        configuration = economy.getConfiguration();
        Console.log("Plugin constructed...");
    }

    @Listener
    public void registerEconomyService(ProvideServiceEvent.EngineScoped<MultiCurrencyService> event) {
        event.suggest(() -> new EconomyServiceAdapter(economy.getApi()));
    }

    @Listener
    public void onServerStarting(StartingEngineEvent<Server> event) {
        this.registerEvents();
    }

    @Listener
    public void onServerStopping(StoppingEngineEvent<Server> event) {
        Economy.shutdown();
    }

    @Listener
    public void onRegisterCommands(RegisterCommandEvent<Command.Parameterized> event) {
        CommandRegister.registerCommands(event, container, CommandsFactory.Commands.getMainCommands());
    }

    private void registerEvents() {
        if (configuration.getBoolean("online")) {
            if (!Sponge.server().isOnlineModeEnabled()) {
                Console.logError("THE SERVER IS IN OFFLINE MODE but the plugin is configured to work in ONLINE mode, please change the configuration to avoid issues.");
            }
            Sponge.eventManager().registerListeners(container, (Object)new PlayerJoinListenerOnline(economy.getPlayerJoinListener()), MethodHandles.lookup());
            Console.log("Online mode is enabled. The plugin will use UUID to identify players.");
        }
        if (!configuration.getBoolean("online")) {
            if (Sponge.server().isOnlineModeEnabled()) {
                Console.logError("THE SERVER IS IN ONLINE MODE but the plugin is configured to work in OFFLINE mode, please change the configuration to avoid issues.");
            }
            Sponge.eventManager().registerListeners(container, (Object)new PlayerJoinListenerOffline(economy.getPlayerJoinListener()), MethodHandles.lookup());
            Console.log("Online mode is disabled, The plugin will use NICKNAME to identify players.");
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static PluginContainer getPlugin() {
        return container;
    }

    public static RawDataChannel getChannel() {
        return channel;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

