/*
 * Decompiled with CFR 0.152.
 */
package lib.commands;

import BlockDynasty.Economy.aplication.useCase.AccountsUseCase;
import BlockDynasty.Economy.aplication.useCase.CurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.OfferUseCase;
import BlockDynasty.Economy.aplication.useCase.TransactionsUseCase;
import java.util.ArrayList;
import java.util.List;
import lib.abstractions.PlatformAdapter;
import lib.commands.abstractions.Command;
import lib.commands.templates.administrators.EconomyCommand;
import lib.commands.templates.administrators.EconomyGUICommand;
import lib.commands.templates.administrators.EconomySubcommand.BuyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.CreateCurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.DeleteCurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditColorCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditDecimalsCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditPayableCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditPluralNameCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditRateCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditSingularNameCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditStartBalCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditSymbolCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.ListCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.SetDefaultCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.ViewCommand;
import lib.commands.templates.administrators.EconomySubcommand.DepositCommand;
import lib.commands.templates.administrators.EconomySubcommand.SetCommand;
import lib.commands.templates.administrators.EconomySubcommand.WithdrawCommand;
import lib.commands.templates.users.BalanceCommand;
import lib.commands.templates.users.BalanceTopCommand;
import lib.commands.templates.users.BankGUICommand;
import lib.commands.templates.users.ExchangeCommand;
import lib.commands.templates.users.OfferCommand;
import lib.commands.templates.users.OfferSubCommand.AcceptOfferCommand;
import lib.commands.templates.users.OfferSubCommand.CancelOfferCommand;
import lib.commands.templates.users.OfferSubCommand.CreateOfferCommand;
import lib.commands.templates.users.OfferSubCommand.DenyOfferCommand;
import lib.commands.templates.users.PayCommand;
import lib.messages.MessageProvider;
import lib.messages.MessageService;

public class CommandsFactory {
    private static PlatformAdapter platformAdapter;
    private static TransactionsUseCase transactionsUseCase;
    private static CurrencyUseCase currencyUseCase;
    private static AccountsUseCase accountsUseCase;
    private static MessageService messageService;
    private static OfferUseCase offerUseCase;

    public static void init(TransactionsUseCase transactionsUseCase, OfferUseCase offerUseCase, CurrencyUseCase currencyUseCase, AccountsUseCase accountsUseCase, PlatformAdapter platformAdapter) {
        CommandsFactory.transactionsUseCase = transactionsUseCase;
        CommandsFactory.offerUseCase = offerUseCase;
        CommandsFactory.accountsUseCase = accountsUseCase;
        CommandsFactory.currencyUseCase = currencyUseCase;
        CommandsFactory.platformAdapter = platformAdapter;
        Commands.init();
    }

    public static void init(TransactionsUseCase transactionsUseCase, OfferUseCase offerUseCase, CurrencyUseCase currencyUseCase, AccountsUseCase accountsUseCase, PlatformAdapter platformAdapter, MessageProvider messageProvider) {
        MessageService.setProvider(messageProvider);
        CommandsFactory.init(transactionsUseCase, offerUseCase, currencyUseCase, accountsUseCase, platformAdapter);
    }

    public static PlatformAdapter getPlatformAdapter() {
        return platformAdapter;
    }

    public static MessageService getMessageProvider() {
        return messageService;
    }

    static {
        messageService = new MessageService();
    }

    public static class Commands {
        private static final List<Command> MainCommands = new ArrayList<Command>();

        public static void init() {
            OfferCommand offerCommand = new OfferCommand();
            EconomyCommand economyCommand = new EconomyCommand();
            CurrencyCommand currencyCommand = new CurrencyCommand();
            WithdrawCommand withdrawCommand = new WithdrawCommand(transactionsUseCase.getWithdrawUseCase());
            DepositCommand depositCommand = new DepositCommand(transactionsUseCase.getDepositUseCase());
            SetCommand setCommand = new SetCommand(transactionsUseCase.getSetBalanceUseCase());
            CreateCurrencyCommand createCurrencyCommand = new CreateCurrencyCommand(currencyUseCase.getCreateCurrencyUseCase());
            DeleteCurrencyCommand deleteCurrencyCommand = new DeleteCurrencyCommand(currencyUseCase.getDeleteCurrencyUseCase());
            EditColorCommand editColorCommand = new EditColorCommand(currencyUseCase.getEditCurrencyUseCase());
            EditDecimalsCommand editDecimalsCommand = new EditDecimalsCommand(currencyUseCase.getEditCurrencyUseCase());
            EditPayableCommand editPayableCommand = new EditPayableCommand(currencyUseCase.getEditCurrencyUseCase());
            EditRateCommand editRateCommand = new EditRateCommand(currencyUseCase.getEditCurrencyUseCase());
            EditStartBalCommand editStartBalCommand = new EditStartBalCommand(currencyUseCase.getEditCurrencyUseCase());
            ViewCommand ViewCommand2 = new ViewCommand(currencyUseCase.getGetCurrencyUseCase());
            EditSymbolCommand editSymbolCommand = new EditSymbolCommand(currencyUseCase.getEditCurrencyUseCase());
            ListCommand listCommand = new ListCommand(currencyUseCase.getGetCurrencyUseCase());
            SetDefaultCommand setDefaultCommand = new SetDefaultCommand(currencyUseCase.getEditCurrencyUseCase());
            EditPluralNameCommand editPluralNameCommand = new EditPluralNameCommand(currencyUseCase.getEditCurrencyUseCase());
            EditSingularNameCommand editSingularNameCommand = new EditSingularNameCommand(currencyUseCase.getEditCurrencyUseCase());
            BuyCommand buyCommand = new BuyCommand(transactionsUseCase.getWithdrawUseCase());
            CreateOfferCommand createOfferCommand = new CreateOfferCommand(offerUseCase.getCreateOfferUseCase());
            CancelOfferCommand cancelOfferCommand = new CancelOfferCommand(offerUseCase.getCancelOfferUseCase());
            AcceptOfferCommand acceptOfferCommand = new AcceptOfferCommand(offerUseCase.getAcceptOfferUseCase());
            DenyOfferCommand denyOfferCommand = new DenyOfferCommand(offerUseCase.getCancelOfferUseCase());
            PayCommand payCommand = new PayCommand(transactionsUseCase.getPayUseCase());
            BalanceCommand balanceCommand = new BalanceCommand(accountsUseCase.getGetBalanceUseCase());
            BalanceTopCommand balanceTopCommand = new BalanceTopCommand(accountsUseCase.getGetAccountsUseCase());
            ExchangeCommand exchangeCommand = new ExchangeCommand(transactionsUseCase.getExchangeUseCase());
            BankGUICommand bankGUICommand = new BankGUICommand();
            EconomyGUICommand economyGUICommand = new EconomyGUICommand();
            economyCommand.registerSubCommand(withdrawCommand);
            economyCommand.registerSubCommand(depositCommand);
            economyCommand.registerSubCommand(setCommand);
            economyCommand.registerSubCommand(buyCommand);
            economyCommand.registerSubCommand(currencyCommand);
            economyCommand.registerSubCommand(economyGUICommand);
            currencyCommand.registerSubCommand(createCurrencyCommand);
            currencyCommand.registerSubCommand(deleteCurrencyCommand);
            currencyCommand.registerSubCommand(ViewCommand2);
            currencyCommand.registerSubCommand(editColorCommand);
            currencyCommand.registerSubCommand(editDecimalsCommand);
            currencyCommand.registerSubCommand(editPayableCommand);
            currencyCommand.registerSubCommand(editRateCommand);
            currencyCommand.registerSubCommand(editStartBalCommand);
            currencyCommand.registerSubCommand(editSymbolCommand);
            currencyCommand.registerSubCommand(listCommand);
            currencyCommand.registerSubCommand(setDefaultCommand);
            currencyCommand.registerSubCommand(editPluralNameCommand);
            currencyCommand.registerSubCommand(editSingularNameCommand);
            offerCommand.registerSubCommand(createOfferCommand);
            offerCommand.registerSubCommand(cancelOfferCommand);
            offerCommand.registerSubCommand(acceptOfferCommand);
            offerCommand.registerSubCommand(denyOfferCommand);
            MainCommands.add(economyCommand);
            MainCommands.add(offerCommand);
            MainCommands.add(payCommand);
            MainCommands.add(balanceCommand);
            MainCommands.add(balanceTopCommand);
            MainCommands.add(exchangeCommand);
            MainCommands.add(bankGUICommand);
        }

        public static List<Command> getMainCommands() {
            return MainCommands;
        }

        public static Command getCommand(String commandName) {
            for (Command command : MainCommands) {
                if (!command.getName().equalsIgnoreCase(commandName)) continue;
                return command;
            }
            return null;
        }

        public static void registerMainCommand(Command command) {
            if (Commands.getCommand(command.getName()) == null) {
                MainCommands.add(command);
            }
        }

        public static void registerSubCommand(String mainCommand, Command subCommand) {
            Command command = Commands.getCommand(mainCommand);
            if (command != null) {
                command.registerSubCommand(subCommand);
            }
        }
    }
}

