/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.users;

import BlockDynasty.Economy.aplication.useCase.transaction.PayUseCase;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import lib.abstractions.IPlayer;
import lib.commands.CommandsFactory;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class PayCommand
extends AbstractCommand {
    private final PayUseCase pay;

    public PayCommand(PayUseCase pay) {
        super("pay", "BlockDynastyEconomy.players.pay", List.of("player", "amount", "currency"));
        this.pay = pay;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String targetName = args[0];
        IPlayer target = CommandsFactory.getPlatformAdapter().getPlayer(targetName);
        if (target == null) {
            sender.sendMessage("The player is not online");
            return false;
        }
        String currencyName = args[2];
        BigDecimal amount = BigDecimal.ZERO;
        try {
            amount = new BigDecimal(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("Invalid amount");
            return false;
        }
        BigDecimal finalAmount = amount;
        Result<Void> result = this.pay.execute(sender.getName(), targetName, currencyName, finalAmount);
        if (!result.isSuccess()) {
            sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
        }
        return true;
    }
}

