/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.currencies;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import java.util.Map;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public class EditCurrencyPanel
extends AbstractPanel {
    private final IEntityGUI player;
    private final Currency currency;
    private final EditCurrencyUseCase editCurrencyUseCase;
    private final ITextInput textInput;

    public EditCurrencyPanel(IEntityGUI player, Currency currency, EditCurrencyUseCase editCurrencyUseCase, IGUI parentGUI, ITextInput textInput) {
        super(Message.process(Map.of("currency", currency.getSingular()), "EditCurrencyPanel.title"), 5, player, parentGUI);
        this.player = player;
        this.currency = currency;
        this.textInput = textInput;
        this.editCurrencyUseCase = editCurrencyUseCase;
        this.setupGUI();
    }

    private void setupGUI() {
        String color = ChatColor.stringValueOf(this.currency.getColor());
        this.setItem(4, this.createItem(Materials.GOLD_INGOT, Message.process(Map.of("currency", color + this.currency.getSingular() + " / " + this.currency.getPlural()), "EditCurrencyPanel.button1.nameItem"), Message.processLines(Map.of("symbol", color + this.currency.getSymbol(), "color", color + this.currency.getColor(), "balance", color + String.valueOf(this.currency.getDefaultBalance()), "rate", color + this.currency.getExchangeRate(), "transferable", this.currency.isTransferable() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No", "default", this.currency.isDefaultCurrency() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No", "decimals", this.currency.isDecimalSupported() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No"), "EditCurrencyPanel.button1.lore")), null);
        this.setItem(11, this.createItem(Materials.EMERALD_BLOCK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button2.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button2.lore")), f -> this.openStartBalanceInput());
        this.setItem(13, this.createItem(Materials.GOLD_NUGGET, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button3.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button3.lore")), f -> this.openExchangeRateInput());
        this.setItem(15, this.createItem(Materials.LIME_DYE, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button4.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button4.lore")), f -> this.openColorSelectionGUI());
        this.setItem(20, this.createItem(Materials.NAME_TAG, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button5.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button5.lore")), f -> this.openSymbolInput());
        this.setItem(22, this.createItem(Materials.NETHER_STAR, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button6.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button6.lore")), f -> {
            try {
                this.editCurrencyUseCase.setDefaultCurrency(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + this.currency.getSingular() + " is now the default currency.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(24, this.createItem(this.currency.isTransferable() ? Materials.LIME_CONCRETE : Materials.RED_CONCRETE, this.currency.isTransferable() ? "Transferable: " + ChatColor.stringValueOf(Colors.GREEN) + "Activated" : "Transferable: " + ChatColor.stringValueOf(Colors.RED) + "Disabled", ChatColor.stringValueOf(Colors.GRAY) + "Click to " + (this.currency.isTransferable() ? "Disable" : "Enable"), "This option affects:", "Transfer", "Pay", "Trade/Offers"), f -> {
            try {
                this.editCurrencyUseCase.togglePayable(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Transfer option changed");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(29, this.createItem(Materials.PAPER, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button7.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button7.lore")), f -> this.openSingularNameInput());
        this.setItem(31, this.createItem(Materials.BOOK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "EditCurrencyPanel.button8.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "EditCurrencyPanel.button8.lore")), f -> this.openPluralNameInput());
        this.setItem(33, this.createItem(this.currency.isDecimalSupported() ? Materials.LIME_CONCRETE : Materials.RED_CONCRETE, this.currency.isDecimalSupported() ? "Decimals support: " + ChatColor.stringValueOf(Colors.GREEN) + "Activated" : "Decimals support: " + ChatColor.stringValueOf(Colors.RED) + "Disabled", "Click to " + (this.currency.isDecimalSupported() ? "Disable" : "Enable") + " decimal support"), f -> {
            try {
                this.editCurrencyUseCase.toggleDecimals(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Decimal support changed.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(40, this.createItem(Materials.BARRIER, ChatColor.stringValueOf(Colors.RED) + "Back", ChatColor.stringValueOf(Colors.GRAY) + "Click to go back"), f -> GUIFactory.currencyListToEditPanel(this.player, this.getParent().getParent()).open());
    }

    private void openEditCurrencyGUI() {
        GUIFactory.editCurrencyPanel(this.player, this.currency, this.getParent()).open();
    }

    private void openColorSelectionGUI() {
        GUIFactory.colorSelectorPanel(this.player, this.currency, this).open();
    }

    private void openStartBalanceInput() {
        this.textInput.open(this, this.player, "Initial balance:" + this.currency.getSingular(), this.currency.getDefaultBalance().toString(), s -> {
            try {
                double startBal = Double.parseDouble(s);
                try {
                    this.editCurrencyUseCase.editStartBal(this.currency.getSingular(), startBal);
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Initial balance updated correctly.");
                    this.openEditCurrencyGUI();
                }
                catch (Exception e) {
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                    this.openEditCurrencyGUI();
                }
            }
            catch (NumberFormatException e) {
                return "Invalid format";
            }
            return null;
        });
    }

    private void openExchangeRateInput() {
        this.textInput.open(this, this.player, "Exchange rate:" + this.currency.getSingular(), String.valueOf(this.currency.getExchangeRate()), s -> {
            try {
                double rate = Double.parseDouble(s);
                try {
                    this.editCurrencyUseCase.setCurrencyRate(this.currency.getSingular(), rate);
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Exchange rate updated correctly.");
                    this.openEditCurrencyGUI();
                }
                catch (Exception e) {
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                    this.openEditCurrencyGUI();
                }
            }
            catch (NumberFormatException e) {
                return "Invalid format";
            }
            return null;
        });
    }

    private void openSymbolInput() {
        this.textInput.open(this, this.player, "Symbol:" + this.currency.getSingular(), this.currency.getSymbol(), s -> {
            try {
                this.editCurrencyUseCase.editSymbol(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Symbol updated successfully.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }

    private void openSingularNameInput() {
        this.textInput.open(this, this.player, "Singular Name", this.currency.getSingular(), s -> {
            try {
                this.editCurrencyUseCase.setSingularName(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Singular name updated correctly.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }

    private void openPluralNameInput() {
        this.textInput.open(this, this.player, "Plural Name", this.currency.getPlural(), s -> {
            try {
                this.editCurrencyUseCase.setPluralName(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Plural noun updated correctly.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }
}

