/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import jakarta.persistence.FetchType;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.Discriminatable;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAnyAssociationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAuxiliaryDatabaseObjectType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCacheInclusionEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmClassRenameType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDynamicComponentType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchProfileType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleWithSubselectEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterAliasMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdBagCollectionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdentifierGeneratorDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmKeyType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithExtraEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithNoProxyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmMapType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedNativeQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryPropertyReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNotFoundEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOnDeleteEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOuterJoinEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPolymorphismEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPrimitiveArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPropertiesType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmQueryParamType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmResultSetMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSecondaryTableType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSetType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSynchronizeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTimestampAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmToolingHintContainer;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmVersionAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.PluralAttributeInfo;
import org.hibernate.boot.jaxb.hbm.spi.ResultSetMappingContainer;
import org.hibernate.boot.jaxb.hbm.spi.ToolingHintContainer;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaSource;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaTarget;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaults;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsBasicImpl;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsInsertableNonUpdateableImpl;
import org.hibernate.boot.jaxb.hbm.transform.HbmTransformationLogging;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapterJaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbColumn;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbJoinColumn;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.mapping.AttributesContainer;
import org.hibernate.boot.jaxb.mapping.CollectionAttribute;
import org.hibernate.boot.jaxb.mapping.JaxbAttributes;
import org.hibernate.boot.jaxb.mapping.JaxbBasic;
import org.hibernate.boot.jaxb.mapping.JaxbCacheInclusionType;
import org.hibernate.boot.jaxb.mapping.JaxbCaching;
import org.hibernate.boot.jaxb.mapping.JaxbCascadeType;
import org.hibernate.boot.jaxb.mapping.JaxbCollectionTable;
import org.hibernate.boot.jaxb.mapping.JaxbColumn;
import org.hibernate.boot.jaxb.mapping.JaxbColumnResult;
import org.hibernate.boot.jaxb.mapping.JaxbCustomLoader;
import org.hibernate.boot.jaxb.mapping.JaxbCustomSql;
import org.hibernate.boot.jaxb.mapping.JaxbDatabaseObject;
import org.hibernate.boot.jaxb.mapping.JaxbDatabaseObjectScope;
import org.hibernate.boot.jaxb.mapping.JaxbDiscriminatorColumn;
import org.hibernate.boot.jaxb.mapping.JaxbElementCollection;
import org.hibernate.boot.jaxb.mapping.JaxbEmbeddable;
import org.hibernate.boot.jaxb.mapping.JaxbEmbeddableAttributes;
import org.hibernate.boot.jaxb.mapping.JaxbEmbedded;
import org.hibernate.boot.jaxb.mapping.JaxbEmbeddedId;
import org.hibernate.boot.jaxb.mapping.JaxbEmptyType;
import org.hibernate.boot.jaxb.mapping.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.jaxb.mapping.JaxbEntityResult;
import org.hibernate.boot.jaxb.mapping.JaxbFetchProfile;
import org.hibernate.boot.jaxb.mapping.JaxbFieldResult;
import org.hibernate.boot.jaxb.mapping.JaxbFilterDef;
import org.hibernate.boot.jaxb.mapping.JaxbForeignKey;
import org.hibernate.boot.jaxb.mapping.JaxbGenericIdGenerator;
import org.hibernate.boot.jaxb.mapping.JaxbHbmAnyDiscriminator;
import org.hibernate.boot.jaxb.mapping.JaxbHbmAnyDiscriminatorValueMapping;
import org.hibernate.boot.jaxb.mapping.JaxbHbmAnyKey;
import org.hibernate.boot.jaxb.mapping.JaxbHbmAnyMapping;
import org.hibernate.boot.jaxb.mapping.JaxbHbmFilter;
import org.hibernate.boot.jaxb.mapping.JaxbHbmManyToAny;
import org.hibernate.boot.jaxb.mapping.JaxbHqlImport;
import org.hibernate.boot.jaxb.mapping.JaxbId;
import org.hibernate.boot.jaxb.mapping.JaxbIdClass;
import org.hibernate.boot.jaxb.mapping.JaxbInheritance;
import org.hibernate.boot.jaxb.mapping.JaxbJoinColumn;
import org.hibernate.boot.jaxb.mapping.JaxbManyToMany;
import org.hibernate.boot.jaxb.mapping.JaxbManyToOne;
import org.hibernate.boot.jaxb.mapping.JaxbMapKeyColumn;
import org.hibernate.boot.jaxb.mapping.JaxbNamedNativeQuery;
import org.hibernate.boot.jaxb.mapping.JaxbNamedQuery;
import org.hibernate.boot.jaxb.mapping.JaxbNaturalId;
import org.hibernate.boot.jaxb.mapping.JaxbOneToMany;
import org.hibernate.boot.jaxb.mapping.JaxbOneToOne;
import org.hibernate.boot.jaxb.mapping.JaxbOrderColumn;
import org.hibernate.boot.jaxb.mapping.JaxbPersistenceUnitMetadata;
import org.hibernate.boot.jaxb.mapping.JaxbPluralFetchMode;
import org.hibernate.boot.jaxb.mapping.JaxbPrimaryKeyJoinColumn;
import org.hibernate.boot.jaxb.mapping.JaxbQueryParamType;
import org.hibernate.boot.jaxb.mapping.JaxbSecondaryTable;
import org.hibernate.boot.jaxb.mapping.JaxbSingularFetchMode;
import org.hibernate.boot.jaxb.mapping.JaxbSqlResultSetMapping;
import org.hibernate.boot.jaxb.mapping.JaxbSynchronizedTable;
import org.hibernate.boot.jaxb.mapping.JaxbTable;
import org.hibernate.boot.jaxb.mapping.JaxbTransient;
import org.hibernate.boot.jaxb.mapping.JaxbVersion;
import org.hibernate.boot.jaxb.mapping.ToOneAttribute;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.jboss.logging.Logger;

public class HbmXmlTransformer {
    private final Origin origin;
    private final JaxbHbmHibernateMapping hbmXmlMapping;
    private final JaxbEntityMappings ormRoot;
    private final Options options;
    private int counter = 1;

    public static JaxbEntityMappings transform(JaxbHbmHibernateMapping hbmXmlMapping, Origin origin, Options options) {
        return new HbmXmlTransformer(hbmXmlMapping, origin, options).doTransform();
    }

    public HbmXmlTransformer(JaxbHbmHibernateMapping hbmXmlMapping, Origin origin, Options options) {
        this.origin = origin;
        this.hbmXmlMapping = hbmXmlMapping;
        this.options = options;
        this.ormRoot = new JaxbEntityMappings();
        this.ormRoot.setDescription("mapping.xml document auto-generated from legacy hbm.xml format via transformation - " + origin.getName());
    }

    private JaxbEntityMappings doTransform() {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.tracef("Starting hbm.xml transformation - `%s`", (Object)this.origin);
        JaxbPersistenceUnitMetadata metadata = new JaxbPersistenceUnitMetadata();
        this.ormRoot.setPersistenceUnitMetadata(metadata);
        this.transfer(this.hbmXmlMapping::getPackage, this.ormRoot::setPackage);
        this.transfer(this.hbmXmlMapping::getCatalog, this.ormRoot::setCatalog);
        this.transfer(this.hbmXmlMapping::getSchema, this.ormRoot::setSchema);
        this.transfer(this.hbmXmlMapping::getDefaultAccess, this.ormRoot::setAttributeAccessor);
        this.transfer(this.hbmXmlMapping::getDefaultCascade, this.ormRoot::setDefaultCascade);
        this.transfer(this.hbmXmlMapping::isDefaultLazy, this.ormRoot::setDefaultLazy);
        this.transferIdentifierGenerators();
        this.transferTypeDefs();
        this.transferFilterDefinitions();
        this.transferImports();
        this.transferEntities();
        this.transferResultSetMappings();
        this.transferNamedQueries();
        this.transferNamedNativeQueries();
        this.transferFetchProfiles();
        this.transferDatabaseObjects();
        return this.ormRoot;
    }

    private <T> void transfer(Supplier<T> source, Consumer<T> target) {
        T value = source.get();
        if (value != null) {
            target.accept(value);
        }
    }

    private void handleUnsupportedContent(String description) {
        this.handleUnsupported("Transformation of hbm.xml `%s` encountered unsupported content : %s", this.origin.toString(), description);
    }

    private void handleUnsupported(String message, Object ... messageArgs) {
        if (this.options.unsupportedFeatureHandling() == UnsupportedFeatureHandling.ERROR) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, message, messageArgs));
        }
        Logger.Level logLevel = this.options.unsupportedFeatureHandling() == UnsupportedFeatureHandling.WARN ? Logger.Level.WARN : Logger.Level.DEBUG;
        HbmTransformationLogging.TRANSFORMATION_LOGGER.log(logLevel, (Object)message, messageArgs);
    }

    private void transferTypeDefs() {
        if (this.hbmXmlMapping.getTypedef().isEmpty()) {
            return;
        }
        this.handleUnsupported("Transformation of type-def mapping not supported - `%s`", this.origin);
    }

    private void transferIdentifierGenerators() {
        if (this.hbmXmlMapping.getIdentifierGenerator().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of identifier-generator mappings in `%s`", (Object)this.origin);
        for (JaxbHbmIdentifierGeneratorDefinitionType hbmGenerator : this.hbmXmlMapping.getIdentifierGenerator()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of identifier-generator mapping `%s` - `%s`", (Object)hbmGenerator.getName(), (Object)this.origin);
            JaxbGenericIdGenerator generatorDef = new JaxbGenericIdGenerator();
            this.ormRoot.getGenericGenerators().add(generatorDef);
            generatorDef.setName(hbmGenerator.getName());
            generatorDef.setClazz(hbmGenerator.getClazz());
        }
    }

    private void transferFilterDefinitions() {
        if (this.hbmXmlMapping.getFilterDef().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of filter-def mappings in `%s`", (Object)this.origin);
        for (JaxbHbmFilterDefinitionType hbmFilterDef : this.hbmXmlMapping.getFilterDef()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of filter-def mapping `%s` - `%s`", (Object)hbmFilterDef.getName(), (Object)this.origin);
            JaxbFilterDef filterDef = new JaxbFilterDef();
            this.ormRoot.getFilterDefinitions().add(filterDef);
            filterDef.setName(hbmFilterDef.getName());
            boolean foundCondition = false;
            for (Serializable content : hbmFilterDef.getContent()) {
                if (content instanceof String) {
                    String condition = ((String)((Object)content)).trim();
                    if (StringHelper.isEmpty(condition)) continue;
                    foundCondition = true;
                    filterDef.setCondition(condition);
                    continue;
                }
                JaxbHbmFilterParameterType hbmFilterParam = (JaxbHbmFilterParameterType)((JAXBElement)content).getValue();
                JaxbFilterDef.JaxbFilterParam param = new JaxbFilterDef.JaxbFilterParam();
                filterDef.getFilterParam().add(param);
                param.setName(hbmFilterParam.getParameterName());
                param.setType(hbmFilterParam.getParameterValueTypeName());
            }
            if (foundCondition) continue;
            filterDef.setCondition(hbmFilterDef.getCondition());
        }
    }

    private void transferImports() {
        if (this.hbmXmlMapping.getImport().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of import mappings - `%s`", (Object)this.origin);
        for (JaxbHbmClassRenameType hbmImport : this.hbmXmlMapping.getImport()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of import `%s` -> `%s` - `%s`", (Object)hbmImport.getClazz(), (Object)hbmImport.getRename(), (Object)this.origin);
            JaxbHqlImport ormImport = new JaxbHqlImport();
            this.ormRoot.getHqlImports().add(ormImport);
            ormImport.setClazz(hbmImport.getClazz());
            ormImport.setRename(hbmImport.getRename());
        }
    }

    private void transferResultSetMappings() {
        if (this.hbmXmlMapping.getResultset().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of resultset mappings - `%s`", (Object)this.origin);
        for (JaxbHbmResultSetMappingType hbmResultSet : this.hbmXmlMapping.getResultset()) {
            JaxbSqlResultSetMapping mapping = this.transformResultSetMapping(null, hbmResultSet);
            this.ormRoot.getSqlResultSetMappings().add(mapping);
        }
    }

    private JaxbSqlResultSetMapping transformResultSetMapping(String namePrefix, JaxbHbmResultSetMappingType hbmResultSet) {
        String resultMappingName = namePrefix == null ? hbmResultSet.getName() : namePrefix + "." + hbmResultSet.getName();
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of resultset mapping `{}` in `{}`", (Object)resultMappingName, (Object)this.origin);
        JaxbSqlResultSetMapping mapping = new JaxbSqlResultSetMapping();
        mapping.setName(resultMappingName);
        mapping.setDescription("SQL ResultSet mapping - " + resultMappingName);
        for (Serializable hbmReturn : hbmResultSet.getValueMappingSources()) {
            if (hbmReturn instanceof JaxbHbmNativeQueryReturnType) {
                mapping.getEntityResult().add(this.transferEntityReturnElement(resultMappingName, (JaxbHbmNativeQueryReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryScalarReturnType) {
                mapping.getColumnResult().add(this.transferScalarReturnElement(resultMappingName, (JaxbHbmNativeQueryScalarReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-join/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <collection-load/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained an unexpected element type", resultMappingName));
        }
        return mapping;
    }

    private JaxbEntityResult transferEntityReturnElement(String resultMappingName, JaxbHbmNativeQueryReturnType hbmReturn) {
        JaxbEntityResult entityResult = new JaxbEntityResult();
        entityResult.setEntityClass(this.getFullyQualifiedClassName(hbmReturn.getClazz()));
        for (JaxbHbmNativeQueryPropertyReturnType propertyReturn : hbmReturn.getReturnProperty()) {
            JaxbFieldResult field = new JaxbFieldResult();
            ArrayList<String> columns = new ArrayList<String>();
            if (!StringHelper.isEmpty(propertyReturn.getColumn())) {
                columns.add(propertyReturn.getColumn());
            }
            for (JaxbHbmNativeQueryPropertyReturnType.JaxbHbmReturnColumn returnColumn : propertyReturn.getReturnColumn()) {
                columns.add(returnColumn.getName());
            }
            if (columns.size() > 1) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-property name='%s'/> element declaring multiple 1 column mapping, which is not supported for transformation;skipping that return-property mapping", resultMappingName, propertyReturn.getName()));
                continue;
            }
            field.setColumn((String)columns.get(0));
            field.setName(propertyReturn.getName());
            entityResult.getFieldResult().add(field);
        }
        return entityResult;
    }

    private JaxbColumnResult transferScalarReturnElement(String resultMappingName, JaxbHbmNativeQueryScalarReturnType hbmReturn) {
        JaxbColumnResult columnResult = new JaxbColumnResult();
        columnResult.setName(hbmReturn.getColumn());
        columnResult.setClazz(hbmReturn.getType());
        this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-scalar column='%s'/> element; transforming type->class likely requires manual adjustment", resultMappingName, hbmReturn.getColumn()));
        return columnResult;
    }

    private void transferFetchProfiles() {
        if (this.hbmXmlMapping.getFetchProfile().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of fetch-profile mappings in `{}`", (Object)this.origin);
        for (JaxbHbmFetchProfileType hbmFetchProfile : this.hbmXmlMapping.getFetchProfile()) {
            this.ormRoot.getFetchProfiles().add(this.transferFetchProfile(hbmFetchProfile));
        }
    }

    private JaxbFetchProfile transferFetchProfile(JaxbHbmFetchProfileType hbmFetchProfile) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of fetch-profile mapping `{}` in `{}`", (Object)hbmFetchProfile.getName(), (Object)this.origin);
        JaxbFetchProfile fetchProfile = new JaxbFetchProfile();
        fetchProfile.setName(hbmFetchProfile.getName());
        for (JaxbHbmFetchProfileType.JaxbHbmFetch hbmFetch : hbmFetchProfile.getFetch()) {
            JaxbFetchProfile.JaxbFetch fetch = new JaxbFetchProfile.JaxbFetch();
            fetchProfile.getFetch().add(fetch);
            fetch.setEntity(hbmFetch.getEntity());
            fetch.setAssociation(hbmFetch.getAssociation());
            fetch.setStyle(hbmFetch.getStyle().value());
        }
        return fetchProfile;
    }

    private void transferNamedQueries() {
        if (this.hbmXmlMapping.getQuery().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of named-query mappings in `{}`", (Object)this.origin);
        for (JaxbHbmNamedQueryType hbmQuery : this.hbmXmlMapping.getQuery()) {
            this.ormRoot.getNamedQueries().add(this.transformNamedQuery(hbmQuery, hbmQuery.getName()));
        }
    }

    private JaxbNamedQuery transformNamedQuery(JaxbHbmNamedQueryType hbmQuery, String name) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of named-query mapping `{}` in `{}`", (Object)name, (Object)this.origin);
        JaxbNamedQuery query = new JaxbNamedQuery();
        query.setName(name);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String s = (String)((Object)content);
                s = s.trim();
                query.setQuery(s);
                continue;
            }
            JAXBElement element = (JAXBElement)content;
            JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element.getValue();
            JaxbQueryParamType queryParam = new JaxbQueryParamType();
            query.getQueryParam().add(queryParam);
            queryParam.setName(hbmQueryParam.getName());
            queryParam.setType(hbmQueryParam.getType());
        }
        return query;
    }

    private void transferNamedNativeQueries() {
        if (this.hbmXmlMapping.getSqlQuery().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of (named) query mappings in `{}`", (Object)this.origin);
        for (JaxbHbmNamedNativeQueryType hbmQuery : this.hbmXmlMapping.getSqlQuery()) {
            this.ormRoot.getNamedNativeQueries().add(this.transformNamedNativeQuery(hbmQuery, hbmQuery.getName()));
        }
    }

    private JaxbNamedNativeQuery transformNamedNativeQuery(JaxbHbmNamedNativeQueryType hbmQuery, String queryName) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of (named) query mapping `{}` in `{}`", (Object)queryName, (Object)this.origin);
        String implicitResultSetMappingName = queryName + "-implicitResultSetMapping";
        JaxbNamedNativeQuery query = new JaxbNamedNativeQuery();
        query.setName(queryName);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        JaxbSqlResultSetMapping implicitResultSetMapping = null;
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String s = (String)((Object)content);
                s = s.trim();
                query.setQuery(s);
                continue;
            }
            if (!(content instanceof JAXBElement)) continue;
            Object element = ((JAXBElement)content).getValue();
            if (element instanceof JaxbHbmQueryParamType) {
                JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element;
                JaxbQueryParamType queryParam = new JaxbQueryParamType();
                queryParam.setName(hbmQueryParam.getName());
                queryParam.setType(hbmQueryParam.getType());
                query.getQueryParam().add(queryParam);
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryScalarReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMapping();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.ormRoot.getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getColumnResult().add(this.transferScalarReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryScalarReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMapping();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.ormRoot.getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getEntityResult().add(this.transferEntityReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <collection-load/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <return-join/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmSynchronizeType) {
                JaxbHbmSynchronizeType hbmSynchronize = (JaxbHbmSynchronizeType)element;
                JaxbSynchronizedTable synchronize = new JaxbSynchronizedTable();
                synchronize.setTable(hbmSynchronize.getTable());
                query.getSynchronizations().add(synchronize);
                continue;
            }
            this.handleUnsupportedContent(String.format("Named native query [name=%s] contained an unexpected element type", queryName));
        }
        return query;
    }

    private void transferDatabaseObjects() {
        if (this.hbmXmlMapping.getDatabaseObject().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of database-object mappings in `{}`", (Object)this.origin);
        for (JaxbHbmAuxiliaryDatabaseObjectType hbmDatabaseObject : this.hbmXmlMapping.getDatabaseObject()) {
            JaxbDatabaseObject databaseObject = new JaxbDatabaseObject();
            this.ormRoot.getDatabaseObjects().add(databaseObject);
            databaseObject.setCreate(hbmDatabaseObject.getCreate());
            databaseObject.setDrop(hbmDatabaseObject.getDrop());
            if (hbmDatabaseObject.getDialectScope().isEmpty()) continue;
            hbmDatabaseObject.getDialectScope().forEach(hbmScope -> {
                JaxbDatabaseObjectScope scope = new JaxbDatabaseObjectScope();
                databaseObject.getDialectScopes().add(scope);
                scope.setName(hbmScope.getName());
            });
        }
    }

    private void transferEntities() {
        JaxbEntity entity;
        for (JaxbHbmRootEntityType jaxbHbmRootEntityType : this.hbmXmlMapping.getClazz()) {
            entity = new JaxbEntity();
            this.ormRoot.getEntities().add(entity);
            this.transferRootEntity(jaxbHbmRootEntityType, entity);
        }
        for (JaxbHbmDiscriminatorSubclassEntityType jaxbHbmDiscriminatorSubclassEntityType : this.hbmXmlMapping.getSubclass()) {
            entity = new JaxbEntity();
            this.ormRoot.getEntities().add(entity);
            this.transferDiscriminatorSubclass(jaxbHbmDiscriminatorSubclassEntityType, entity);
        }
        for (JaxbHbmJoinedSubclassEntityType jaxbHbmJoinedSubclassEntityType : this.hbmXmlMapping.getJoinedSubclass()) {
            entity = new JaxbEntity();
            this.ormRoot.getEntities().add(entity);
            this.transferJoinedSubclass(jaxbHbmJoinedSubclassEntityType, entity);
        }
        for (JaxbHbmUnionSubclassEntityType jaxbHbmUnionSubclassEntityType : this.hbmXmlMapping.getUnionSubclass()) {
            entity = new JaxbEntity();
            this.ormRoot.getEntities().add(entity);
            this.transferUnionSubclass(jaxbHbmUnionSubclassEntityType, entity);
        }
    }

    private String extractEntityName(EntityInfo entityInfo) {
        if (entityInfo.getEntityName() != null) {
            return entityInfo.getEntityName();
        }
        return entityInfo.getName();
    }

    private void transferRootEntity(JaxbHbmRootEntityType hbmClass, JaxbEntity entity) {
        String name;
        JaxbEntity subclassEntity;
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of root entity `%s` - `%s`", (Object)this.extractEntityName(hbmClass), (Object)this.origin);
        this.transferBaseEntityInformation(hbmClass, entity);
        entity.setMutable(hbmClass.isMutable());
        if (hbmClass.getTable() != null) {
            entity.setTable(new JaxbTable());
            this.transfer(hbmClass::getTable, entity.getTable()::setName);
            this.transfer(hbmClass::getCatalog, entity.getTable()::setCatalog);
            this.transfer(hbmClass::getSchema, entity.getTable()::setSchema);
            this.transfer(hbmClass::getComment, entity.getTable()::setComment);
            this.transfer(hbmClass::getCheck, entity.getTable()::setCheck);
        } else {
            this.transfer(hbmClass::getSubselect, entity::setTableExpression);
        }
        for (JaxbHbmSynchronizeType jaxbHbmSynchronizeType : hbmClass.getSynchronize()) {
            JaxbSynchronizedTable sync = new JaxbSynchronizedTable();
            sync.setTable(jaxbHbmSynchronizeType.getTable());
            entity.getSynchronize().add(sync);
        }
        if (hbmClass.getLoader() != null) {
            entity.setLoader(new JaxbCustomLoader());
            entity.getLoader().setQueryRef(hbmClass.getLoader().getQueryRef());
        }
        if (hbmClass.getSqlInsert() != null) {
            entity.setSqlInsert(new JaxbCustomSql());
            entity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
            entity.getSqlInsert().setCheck(hbmClass.getSqlInsert().getCheck());
            entity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
        }
        if (hbmClass.getSqlUpdate() != null) {
            entity.setSqlUpdate(new JaxbCustomSql());
            entity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
            entity.getSqlUpdate().setCheck(hbmClass.getSqlUpdate().getCheck());
            entity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
        }
        if (hbmClass.getSqlDelete() != null) {
            entity.setSqlDelete(new JaxbCustomSql());
            entity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
            entity.getSqlDelete().setCheck(hbmClass.getSqlDelete().getCheck());
            entity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
        }
        entity.setRowid(hbmClass.getRowid());
        entity.setWhere(hbmClass.getWhere());
        if (!hbmClass.getTuplizer().isEmpty()) {
            if (this.options.unsupportedFeatureHandling() == UnsupportedFeatureHandling.ERROR) {
                throw new MappingException("HBM transformation: Tuplizer not supported", this.origin);
            }
            HbmTransformationLogging.TRANSFORMATION_LOGGER.logf(this.options.unsupportedFeatureHandling() == UnsupportedFeatureHandling.WARN ? Logger.Level.WARN : Logger.Level.DEBUG, "Transformation of <tuplizer/> is not supported - `%s`", (Object)this.origin);
            return;
        }
        entity.setOptimisticLock(hbmClass.getOptimisticLock());
        entity.setDiscriminatorValue(hbmClass.getDiscriminatorValue());
        entity.setPolymorphism(this.convert(hbmClass.getPolymorphism()));
        this.transferDiscriminator(hbmClass, entity);
        this.transferAttributes(hbmClass, entity);
        if (hbmClass.getCache() != null) {
            this.transformEntityCaching(hbmClass, entity);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            entity.getNamedQuery().add(this.transformNamedQuery(jaxbHbmNamedQueryType, entity.getName() + "." + jaxbHbmNamedQueryType.getName()));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            entity.getNamedNativeQuery().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, entity.getName() + "." + jaxbHbmNamedNativeQueryType.getName()));
        }
        for (JaxbHbmFilterType jaxbHbmFilterType : hbmClass.getFilter()) {
            entity.getFilter().add(this.convert(jaxbHbmFilterType));
        }
        for (JaxbHbmFetchProfileType jaxbHbmFetchProfileType : hbmClass.getFetchProfile()) {
            entity.getFetchProfile().add(this.transferFetchProfile(jaxbHbmFetchProfileType));
        }
        for (JaxbHbmJoinedSubclassEntityType jaxbHbmJoinedSubclassEntityType : hbmClass.getJoinedSubclass()) {
            entity.setInheritance(new JaxbInheritance());
            entity.getInheritance().setStrategy(InheritanceType.JOINED);
            subclassEntity = new JaxbEntity();
            this.ormRoot.getEntities().add(subclassEntity);
            this.transferJoinedSubclass(jaxbHbmJoinedSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmUnionSubclassEntityType jaxbHbmUnionSubclassEntityType : hbmClass.getUnionSubclass()) {
            entity.setInheritance(new JaxbInheritance());
            entity.getInheritance().setStrategy(InheritanceType.TABLE_PER_CLASS);
            subclassEntity = new JaxbEntity();
            this.ormRoot.getEntities().add(subclassEntity);
            this.transferUnionSubclass(jaxbHbmUnionSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmDiscriminatorSubclassEntityType jaxbHbmDiscriminatorSubclassEntityType : hbmClass.getSubclass()) {
            subclassEntity = new JaxbEntity();
            this.ormRoot.getEntities().add(subclassEntity);
            this.transferDiscriminatorSubclass(jaxbHbmDiscriminatorSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedQueryType.getName();
            this.ormRoot.getNamedQueries().add(this.transformNamedQuery(jaxbHbmNamedQueryType, name));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedNativeQueryType.getName();
            this.ormRoot.getNamedNativeQueries().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, name));
        }
    }

    private void transformEntityCaching(JaxbHbmRootEntityType hbmClass, JaxbEntity entity) {
        entity.setCaching(new JaxbCaching());
        entity.getCaching().setRegion(hbmClass.getCache().getRegion());
        entity.getCaching().setAccess(hbmClass.getCache().getUsage());
        entity.getCaching().setInclude(this.convert(hbmClass.getCache().getInclude()));
    }

    private JaxbCacheInclusionType convert(JaxbHbmCacheInclusionEnum hbmInclusion) {
        if (hbmInclusion == null) {
            return null;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.NON_LAZY) {
            return JaxbCacheInclusionType.NON_LAZY;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.ALL) {
            return JaxbCacheInclusionType.ALL;
        }
        throw new IllegalArgumentException("Unrecognized cache-inclusions value : " + hbmInclusion);
    }

    private PolymorphismType convert(JaxbHbmPolymorphismEnum polymorphism) {
        if (polymorphism == null) {
            return null;
        }
        return polymorphism == JaxbHbmPolymorphismEnum.EXPLICIT ? PolymorphismType.EXPLICIT : PolymorphismType.IMPLICIT;
    }

    private void transferBaseEntityInformation(JaxbHbmEntityBaseDefinition hbmClass, JaxbEntity entity) {
        entity.setMetadataComplete(true);
        this.transfer(hbmClass::getEntityName, entity::setName);
        this.transfer(hbmClass::getName, entity::setClazz);
        if (hbmClass instanceof Discriminatable) {
            Discriminatable discriminatable = (Discriminatable)((Object)hbmClass);
            this.transfer(discriminatable::getDiscriminatorValue, entity::setDiscriminatorValue);
        }
        if (hbmClass.isAbstract() != null) {
            this.handleUnsupported("Transformation of abstract entity mappings is not supported : `%s` - `%s`", this.extractEntityName(hbmClass), this.origin);
            return;
        }
        if (hbmClass.getPersister() != null) {
            this.handleUnsupported("Transforming <persister/> mappings not supported - `%s` in `%s`", entity.getName(), this.origin);
            return;
        }
        this.transfer(hbmClass::isLazy, entity::setLazy);
        this.transfer(hbmClass::getProxy, entity::setProxy);
        this.transfer(hbmClass::getBatchSize, entity::setBatchSize);
        this.transfer(hbmClass::isDynamicInsert, entity::setDynamicInsert);
        this.transfer(hbmClass::isDynamicUpdate, entity::setDynamicUpdate);
        this.transfer(hbmClass::isSelectBeforeUpdate, entity::setSelectBeforeUpdate);
        this.transferToolingHints(hbmClass);
        this.transferResultSetMappings(entity.getName(), hbmClass);
    }

    private void transferResultSetMappings(String namePrefix, ResultSetMappingContainer container) {
        List<JaxbHbmResultSetMappingType> resultSetMappings = container.getResultset();
        resultSetMappings.forEach(hbmMapping -> {
            JaxbSqlResultSetMapping mapping = this.transformResultSetMapping(namePrefix, (JaxbHbmResultSetMappingType)hbmMapping);
            this.ormRoot.getSqlResultSetMappings().add(mapping);
        });
    }

    private void transferToolingHints(ToolingHintContainer container) {
        if (CollectionHelper.isNotEmpty(container.getToolingHints())) {
            this.handleUnsupported("Transformation of <meta/> (tooling hint) is not supported - `%s`", this.origin);
        }
    }

    private void transferDiscriminatorSubclass(JaxbHbmDiscriminatorSubclassEntityType hbmSubclass, JaxbEntity subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of subclass entity `%` - `%s`", (Object)this.extractEntityName(hbmSubclass), (Object)this.origin);
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
    }

    private void transferJoinedSubclass(JaxbHbmJoinedSubclassEntityType hbmSubclass, JaxbEntity subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of joined-subclass entity `%` - `%s`", (Object)this.extractEntityName(hbmSubclass), (Object)this.origin);
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
        subclassEntity.setTable(new JaxbTable());
        subclassEntity.getTable().setCatalog(hbmSubclass.getCatalog());
        subclassEntity.getTable().setSchema(hbmSubclass.getSchema());
        subclassEntity.getTable().setName(hbmSubclass.getTable());
        subclassEntity.getTable().setComment(hbmSubclass.getComment());
        subclassEntity.getTable().setCheck(hbmSubclass.getCheck());
        if (hbmSubclass.getKey() != null) {
            JaxbPrimaryKeyJoinColumn joinColumn = new JaxbPrimaryKeyJoinColumn();
            joinColumn.setName(hbmSubclass.getKey().getColumnAttribute());
            subclassEntity.getPrimaryKeyJoinColumn().add(joinColumn);
        }
        if (!hbmSubclass.getJoinedSubclass().isEmpty()) {
            subclassEntity.setInheritance(new JaxbInheritance());
            subclassEntity.getInheritance().setStrategy(InheritanceType.JOINED);
            for (JaxbHbmJoinedSubclassEntityType nestedHbmSubclass : hbmSubclass.getJoinedSubclass()) {
                JaxbEntity nestedSubclassEntity = new JaxbEntity();
                this.ormRoot.getEntities().add(nestedSubclassEntity);
                this.transferJoinedSubclass(nestedHbmSubclass, nestedSubclassEntity);
            }
        }
    }

    private void transferColumnsAndFormulas(ColumnAndFormulaSource source, ColumnAndFormulaTarget target, ColumnDefaults columnDefaults, String tableName) {
        if (StringHelper.isNotEmpty(source.getFormulaAttribute())) {
            target.addFormula(source.getFormulaAttribute());
        } else if (StringHelper.isNotEmpty(source.getColumnAttribute())) {
            TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
            column.setName(source.getColumnAttribute());
            column.setTable(tableName);
            target.addColumn(column);
        } else {
            for (Serializable columnOrFormula : source.getColumnOrFormula()) {
                if (columnOrFormula instanceof String) {
                    target.addFormula((String)((Object)columnOrFormula));
                    continue;
                }
                JaxbHbmColumnType hbmColumn = (JaxbHbmColumnType)columnOrFormula;
                TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
                column.setTable(tableName);
                this.transferColumn(source.wrap(hbmColumn), column);
                target.addColumn(column);
            }
        }
    }

    private void transferColumn(SourceColumnAdapter source, TargetColumnAdapter target) {
        target.setName(source.getName());
        target.setNullable(this.invert(source.isNotNull()));
        target.setUnique(source.isUnique());
        target.setLength(source.getLength());
        target.setScale(source.getScale());
        target.setPrecision(source.getPrecision());
        target.setComment(source.getComment());
        target.setCheck(source.getCheck());
        target.setDefault(source.getDefault());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getRead());
        target.setWrite(source.getWrite());
    }

    private void transferColumn(SourceColumnAdapter source, TargetColumnAdapter target, String tableName, ColumnDefaults columnDefaults) {
        target.setName(source.getName());
        target.setTable(tableName);
        target.setNullable(this.invert(source.isNotNull(), columnDefaults.isNullable()));
        if (source.getLength() != null) {
            target.setLength(source.getLength());
        } else {
            target.setLength(columnDefaults.getLength());
        }
        if (source.getScale() != null) {
            target.setScale(source.getScale());
        } else {
            target.setScale(columnDefaults.getScale());
        }
        if (source.getPrecision() != null) {
            target.setPrecision(source.getPrecision());
        } else {
            target.setPrecision(columnDefaults.getPrecision());
        }
        if (source.isUnique() != null) {
            target.setUnique(source.isUnique());
        } else {
            target.setUnique(columnDefaults.isUnique());
        }
        target.setInsertable(columnDefaults.isInsertable());
        target.setUpdatable(columnDefaults.isUpdateable());
        target.setComment(source.getComment());
        target.setCheck(source.getCheck());
        target.setDefault(source.getDefault());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getRead());
        target.setWrite(source.getWrite());
    }

    private void transferDiscriminator(JaxbHbmRootEntityType hbmClass, JaxbEntity entity) {
        if (hbmClass.getDiscriminator() == null) {
            return;
        }
        if (StringHelper.isNotEmpty(hbmClass.getDiscriminator().getColumnAttribute())) {
            entity.setDiscriminatorColumn(new JaxbDiscriminatorColumn());
            entity.getDiscriminatorColumn().setName(hbmClass.getDiscriminator().getColumnAttribute());
        } else if (StringHelper.isEmpty(hbmClass.getDiscriminator().getFormulaAttribute())) {
            entity.setDiscriminatorFormula(hbmClass.getDiscriminator().getFormulaAttribute());
        } else if (StringHelper.isEmpty(hbmClass.getDiscriminator().getFormula())) {
            entity.setDiscriminatorFormula(hbmClass.getDiscriminator().getFormulaAttribute().trim());
        } else {
            entity.setDiscriminatorColumn(new JaxbDiscriminatorColumn());
            entity.getDiscriminatorColumn().setName(hbmClass.getDiscriminator().getColumn().getName());
            entity.getDiscriminatorColumn().setColumnDefinition(hbmClass.getDiscriminator().getColumn().getSqlType());
            entity.getDiscriminatorColumn().setLength(hbmClass.getDiscriminator().getColumn().getLength());
            entity.getDiscriminatorColumn().setForceSelection(hbmClass.getDiscriminator().isForce());
        }
    }

    private void transferAttributes(JaxbHbmRootEntityType source, JaxbEntity target) {
        this.transferEntityElementAttributes(source, target);
        this.transferIdentifier(source, target);
        this.transferNaturalIdentifiers(source, target);
        this.transferVersion(source, target);
        this.transferTimestamp(source, target);
        this.transferJoins(source, target);
    }

    private void transferEntityElementAttributes(EntityInfo hbmClass, JaxbEntity entity) {
        entity.setAttributes(new JaxbAttributes());
        this.transferAttributes(hbmClass.getAttributes(), entity.getAttributes());
    }

    private void transferAttributes(List hbmAttributeMappings, AttributesContainer attributes) {
        for (Object hbmAttributeMapping : hbmAttributeMappings) {
            Serializable target;
            if (hbmAttributeMapping instanceof JaxbHbmBasicAttributeType) {
                JaxbHbmBasicAttributeType basic = (JaxbHbmBasicAttributeType)hbmAttributeMapping;
                attributes.getBasicAttributes().add(this.transformBasicAttribute(basic));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmCompositeAttributeType) {
                JaxbHbmCompositeAttributeType hbmComponent = (JaxbHbmCompositeAttributeType)hbmAttributeMapping;
                this.ormRoot.getEmbeddables().add(this.convertEmbeddable(hbmComponent));
                attributes.getEmbeddedAttributes().add(this.transformEmbedded(hbmComponent));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmPropertiesType) {
                JaxbHbmPropertiesType hbmProperties = (JaxbHbmPropertiesType)hbmAttributeMapping;
                this.transferAttributes(hbmProperties.getAttributes(), attributes);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmDynamicComponentType) {
                String name = ((JaxbHbmDynamicComponentType)hbmAttributeMapping).getName();
                this.handleUnsupported("<dynamic-component/> mappings not supported for transformation [name=%s]", name);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmOneToOneType) {
                JaxbHbmOneToOneType o2o = (JaxbHbmOneToOneType)hbmAttributeMapping;
                this.transferOneToOne(o2o, attributes);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmManyToOneType) {
                JaxbHbmManyToOneType m2o = (JaxbHbmManyToOneType)hbmAttributeMapping;
                attributes.getManyToOneAttributes().add(this.transformManyToOne(m2o));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmAnyAssociationType) {
                JaxbHbmAnyAssociationType any = (JaxbHbmAnyAssociationType)hbmAttributeMapping;
                attributes.getDiscriminatedAssociations().add(this.transformAnyAttribute(any));
                continue;
            }
            if (!(hbmAttributeMapping instanceof PluralAttributeInfo)) continue;
            PluralAttributeInfo hbmCollection = (PluralAttributeInfo)hbmAttributeMapping;
            if (hbmCollection.getElement() != null || hbmCollection.getCompositeElement() != null) {
                target = new JaxbElementCollection();
                if (hbmCollection.getElement() != null) {
                    this.transferElementInfo(hbmCollection, hbmCollection.getElement(), (JaxbElementCollection)target);
                } else {
                    this.transferElementInfo(hbmCollection, hbmCollection.getCompositeElement(), (JaxbElementCollection)target);
                }
                attributes.getElementCollectionAttributes().add((JaxbElementCollection)target);
                continue;
            }
            if (hbmCollection.getOneToMany() != null) {
                target = new JaxbOneToMany();
                this.transferOneToManyInfo(hbmCollection, hbmCollection.getOneToMany(), (JaxbOneToMany)target);
                attributes.getOneToManyAttributes().add((JaxbOneToMany)target);
                continue;
            }
            if (hbmCollection.getManyToMany() != null) {
                target = new JaxbManyToMany();
                this.transferManyToManyInfo(hbmCollection, hbmCollection.getManyToMany(), (JaxbManyToMany)target);
                attributes.getManyToManyAttributes().add((JaxbManyToMany)target);
                continue;
            }
            if (hbmCollection.getManyToAny() != null) {
                this.handleUnsupported("<many-to-any/> not supported for transformation", new Object[0]);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected node type - " + hbmCollection);
        }
    }

    private JaxbBasic transformBasicAttribute(JaxbHbmBasicAttributeType hbmProp) {
        JaxbBasic basic = new JaxbBasic();
        this.transferBasicAttribute(hbmProp, basic);
        return basic;
    }

    private void transferBasicAttribute(final JaxbHbmBasicAttributeType hbmProp, final JaxbBasic basic) {
        basic.setName(hbmProp.getName());
        basic.setOptional(hbmProp.isNotNull() == null || hbmProp.isNotNull() == false);
        basic.setFetch(FetchType.EAGER);
        basic.setAttributeAccessor(hbmProp.getAccess());
        basic.setOptimisticLock(hbmProp.isOptimisticLock());
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmProp.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return hbmProp.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmProp.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                basic.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                basic.setFormula(formula);
            }
        }, new ColumnDefaults(){

            @Override
            public Boolean isNullable() {
                return HbmXmlTransformer.this.invert(hbmProp.isNotNull());
            }

            @Override
            public Integer getLength() {
                return hbmProp.getLength();
            }

            @Override
            public Integer getScale() {
                return StringHelper.isNotEmpty(hbmProp.getScale()) ? Integer.valueOf(Integer.parseInt(hbmProp.getScale())) : null;
            }

            @Override
            public Integer getPrecision() {
                return StringHelper.isNotEmpty(hbmProp.getPrecision()) ? Integer.valueOf(Integer.parseInt(hbmProp.getPrecision())) : null;
            }

            @Override
            public Boolean isUnique() {
                return hbmProp.isUnique();
            }

            @Override
            public Boolean isInsertable() {
                return hbmProp.isInsert();
            }

            @Override
            public Boolean isUpdateable() {
                return hbmProp.isUpdate();
            }
        }, null);
    }

    private JaxbEmbeddable convertEmbeddable(JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbeddable embeddable = new JaxbEmbeddable();
        embeddable.setMetadataComplete(true);
        embeddable.setClazz(this.determineEmbeddableName(hbmComponent));
        embeddable.setAttributes(new JaxbEmbeddableAttributes());
        this.transferAttributes(hbmComponent.getAttributes(), embeddable.getAttributes());
        return embeddable;
    }

    private String determineEmbeddableName(JaxbHbmCompositeAttributeType hbmComponent) {
        if (StringHelper.isNotEmpty(hbmComponent.getClazz())) {
            return hbmComponent.getClazz();
        }
        return hbmComponent.getName() + "_" + this.counter++;
    }

    private String determineEmbeddableName(JaxbHbmCompositeCollectionElementType hbmComponent, PluralAttributeInfo hbmCollection) {
        if (StringHelper.isNotEmpty(hbmComponent.getClazz())) {
            return hbmComponent.getClazz();
        }
        return hbmCollection.getName() + "_" + this.counter++;
    }

    private JaxbEmbedded transformEmbedded(JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbedded embedded = new JaxbEmbedded();
        embedded.setName(hbmComponent.getName());
        embedded.setAttributeAccessor(hbmComponent.getAccess());
        return embedded;
    }

    private void transferOneToOne(JaxbHbmOneToOneType hbmOneToOne, AttributesContainer attributes) {
        if (!hbmOneToOne.getFormula().isEmpty() || !StringHelper.isEmpty(hbmOneToOne.getFormulaAttribute())) {
            this.handleUnsupported("Transformation of formulas within one-to-ones are not supported - `%s`", this.origin);
            return;
        }
        JaxbOneToOne oneToOne = new JaxbOneToOne();
        oneToOne.setAttributeAccessor(hbmOneToOne.getAccess());
        oneToOne.setCascade(this.convertCascadeType(hbmOneToOne.getCascade()));
        oneToOne.setOrphanRemoval(this.isOrphanRemoval(hbmOneToOne.getCascade()));
        oneToOne.setForeignKey(new JaxbForeignKey());
        oneToOne.getForeignKey().setName(hbmOneToOne.getForeignKey());
        if (!StringHelper.isEmpty(hbmOneToOne.getPropertyRef())) {
            JaxbJoinColumn joinColumn = new JaxbJoinColumn();
            joinColumn.setReferencedColumnName(hbmOneToOne.getPropertyRef());
            oneToOne.getJoinColumn().add(joinColumn);
        }
        oneToOne.setName(hbmOneToOne.getName());
        if (StringHelper.isNotEmpty(hbmOneToOne.getEntityName())) {
            oneToOne.setTargetEntity(hbmOneToOne.getEntityName());
        } else {
            oneToOne.setTargetEntity(hbmOneToOne.getClazz());
        }
        this.transferFetchable(hbmOneToOne.getLazy(), hbmOneToOne.getFetch(), hbmOneToOne.getOuterJoin(), hbmOneToOne.isConstrained(), oneToOne);
        attributes.getOneToOneAttributes().add(oneToOne);
    }

    private JaxbManyToOne transformManyToOne(final JaxbHbmManyToOneType hbmNode) {
        if (hbmNode.getNotFound() != JaxbHbmNotFoundEnum.EXCEPTION) {
            this.handleUnsupported("`not-found` not supported for transformation", new Object[0]);
        }
        final JaxbManyToOne m2o = new JaxbManyToOne();
        m2o.setAttributeAccessor(hbmNode.getAccess());
        m2o.setCascade(this.convertCascadeType(hbmNode.getCascade()));
        m2o.setForeignKey(new JaxbForeignKey());
        m2o.getForeignKey().setName(hbmNode.getForeignKey());
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmNode.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return hbmNode.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmNode.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                m2o.getJoinColumn().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                HbmXmlTransformer.this.handleUnsupportedContent("<many-to-one/> [name=" + hbmNode.getName() + "] specified formula [" + formula + "] which is not supported for transformation; skipping");
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, null);
        m2o.setName(hbmNode.getName());
        m2o.setOptional(hbmNode.isNotNull() == null || hbmNode.isNotNull() == false);
        if (StringHelper.isNotEmpty(hbmNode.getEntityName())) {
            m2o.setTargetEntity(hbmNode.getEntityName());
        } else {
            m2o.setTargetEntity(hbmNode.getClazz());
        }
        this.transferFetchable(hbmNode.getLazy(), hbmNode.getFetch(), hbmNode.getOuterJoin(), null, m2o);
        return m2o;
    }

    private JaxbHbmAnyMapping transformAnyAttribute(JaxbHbmAnyAssociationType source) {
        JaxbHbmAnyMapping target = new JaxbHbmAnyMapping();
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setOptimisticLock(source.isOptimisticLock());
        target.setDiscriminator(new JaxbHbmAnyDiscriminator());
        source.getMetaValue().forEach(sourceMapping -> {
            JaxbHbmAnyDiscriminatorValueMapping mapping = new JaxbHbmAnyDiscriminatorValueMapping();
            mapping.setDiscriminatorValue(sourceMapping.getValue());
            mapping.setCorrespondingEntityName(sourceMapping.getClazz());
            target.getDiscriminator().getValueMappings().add(mapping);
        });
        target.setKey(new JaxbHbmAnyKey());
        return target;
    }

    private void transferCollectionTable(final PluralAttributeInfo source, JaxbElementCollection target) {
        target.setCollectionTable(new JaxbCollectionTable());
        if (StringHelper.isNotEmpty(source.getTable())) {
            target.getCollectionTable().setName(source.getTable());
            target.getCollectionTable().setCatalog(source.getCatalog());
            target.getCollectionTable().setSchema(source.getSchema());
        }
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return source.getKey().getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return new ArrayList<Serializable>(source.getKey().getColumn());
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
            }

            @Override
            public void addFormula(String formula) {
                HbmXmlTransformer.this.handleUnsupportedContent("formula as part of element-collection key is not supported for transformation; skipping");
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, source.getTable());
        if (StringHelper.isNotEmpty(source.getKey().getPropertyRef())) {
            this.handleUnsupportedContent("Foreign-key (<key/>) for persistent collection (name=" + source.getName() + ") specified property-ref which is not supported for transformation; transformed <join-column/> will need manual adjustment of referenced-column-name");
        }
    }

    private void transferCollectionBasicInfo(PluralAttributeInfo source, CollectionAttribute target) {
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setFetchMode(this.convert(source.getFetch()));
        if (source instanceof JaxbHbmSetType) {
            JaxbHbmSetType set = (JaxbHbmSetType)source;
            target.setSort(set.getSort());
            target.setOrderBy(set.getOrderBy());
        } else if (source instanceof JaxbHbmMapType) {
            JaxbHbmMapType map = (JaxbHbmMapType)source;
            target.setSort(map.getSort());
            target.setOrderBy(map.getOrderBy());
            this.transferMapKey((JaxbHbmMapType)source, target);
        } else if (source instanceof JaxbHbmIdBagCollectionType) {
            this.handleUnsupported("collection-id is not supported for transformation", new Object[0]);
        } else if (source instanceof JaxbHbmListType) {
            this.transferListIndex(((JaxbHbmListType)source).getIndex(), ((JaxbHbmListType)source).getListIndex(), target);
        } else if (source instanceof JaxbHbmArrayType) {
            this.transferListIndex(((JaxbHbmArrayType)source).getIndex(), ((JaxbHbmArrayType)source).getListIndex(), target);
        } else if (source instanceof JaxbHbmPrimitiveArrayType) {
            this.transferListIndex(((JaxbHbmPrimitiveArrayType)source).getIndex(), ((JaxbHbmPrimitiveArrayType)source).getListIndex(), target);
        }
    }

    private void transferListIndex(JaxbHbmIndexType index, JaxbHbmListIndexType listIndex, CollectionAttribute target) {
        JaxbOrderColumn orderColumn = new JaxbOrderColumn();
        target.setOrderColumn(orderColumn);
        if (index != null) {
            if (StringHelper.isNotEmpty(index.getColumnAttribute())) {
                orderColumn.setName(index.getColumnAttribute());
            } else if (index.getColumn().size() == 1) {
                JaxbHbmColumnType hbmColumn = index.getColumn().get(0);
                orderColumn.setName(hbmColumn.getName());
                orderColumn.setNullable(this.invert(hbmColumn.isNotNull()));
                orderColumn.setColumnDefinition(hbmColumn.getSqlType());
            }
        } else if (listIndex != null) {
            if (StringHelper.isNotEmpty(listIndex.getColumnAttribute())) {
                orderColumn.setName(listIndex.getColumnAttribute());
            } else if (listIndex.getColumn() != null) {
                orderColumn.setName(listIndex.getColumn().getName());
                orderColumn.setNullable(this.invert(listIndex.getColumn().isNotNull()));
                orderColumn.setColumnDefinition(listIndex.getColumn().getSqlType());
            }
        }
    }

    private void transferMapKey(JaxbHbmMapType source, CollectionAttribute target) {
        if (source.getIndex() != null) {
            JaxbMapKeyColumn mapKey = new JaxbMapKeyColumn();
            mapKey.setName(source.getIndex().getColumnAttribute());
            target.setMapKeyColumn(mapKey);
        } else if (source.getMapKey() != null) {
            if (!StringHelper.isEmpty(source.getMapKey().getFormulaAttribute())) {
                this.handleUnsupported("Transformation of formulas within map-keys are not supported - `%s`", this.origin);
                return;
            }
            JaxbMapKeyColumn mapKey = new JaxbMapKeyColumn();
            mapKey.setName(source.getMapKey().getColumnAttribute());
            target.setMapKeyColumn(mapKey);
        }
    }

    private Boolean invert(Boolean value) {
        return this.invert(value, null);
    }

    private Boolean invert(Boolean value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value == false;
    }

    private JaxbPluralFetchMode convert(JaxbHbmFetchStyleWithSubselectEnum fetch) {
        if (fetch != null) {
            switch (fetch) {
                case SELECT: {
                    return JaxbPluralFetchMode.SELECT;
                }
                case JOIN: {
                    return JaxbPluralFetchMode.JOIN;
                }
                case SUBSELECT: {
                    return JaxbPluralFetchMode.SUBSELECT;
                }
            }
        }
        return null;
    }

    private void transferElementInfo(PluralAttributeInfo hbmCollection, final JaxbHbmBasicCollectionElementType element, final JaxbElementCollection target) {
        this.transferCollectionBasicInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return element.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return element.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return element.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                target.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                target.setFormula(formula);
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, null);
    }

    private void transferElementInfo(PluralAttributeInfo hbmCollection, JaxbHbmCompositeCollectionElementType compositeElement, JaxbElementCollection target) {
        this.transferCollectionBasicInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        String embeddableName = this.determineEmbeddableName(compositeElement, hbmCollection);
        target.setTargetClass(embeddableName);
        JaxbEmbeddable embeddable = new JaxbEmbeddable();
        embeddable.setClazz(embeddableName);
        embeddable.setAttributes(new JaxbEmbeddableAttributes());
        this.transferAttributes(compositeElement.getAttributes(), embeddable.getAttributes());
        this.ormRoot.getEmbeddables().add(embeddable);
    }

    private void transferOneToManyInfo(PluralAttributeInfo hbmAttributeInfo, JaxbHbmOneToManyCollectionElementType hbmOneToMany, JaxbOneToMany target) {
        if (StringHelper.isNotEmpty(hbmAttributeInfo.getCollectionType())) {
            this.handleUnsupported("Collection-type is not supported for transformation", new Object[0]);
        }
        if (CollectionHelper.isNotEmpty(hbmAttributeInfo.getFilter())) {
            this.handleUnsupported("Filters are not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(hbmAttributeInfo.getWhere())) {
            this.handleUnsupported("SQL restrictions are not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlInsert() != null) {
            this.handleUnsupported("<sql-insert/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlUpdate() != null) {
            this.handleUnsupported("<sql-update/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlDelete() != null) {
            this.handleUnsupported("<sql-delete/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlDeleteAll() != null) {
            this.handleUnsupported("<sql-delete-all/> not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.getNode() != null && !hbmOneToMany.getNode().isBlank()) {
            this.handleUnsupported("`node` not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.getNotFound() != JaxbHbmNotFoundEnum.EXCEPTION) {
            this.handleUnsupported("`not-found` not supported for transformation", new Object[0]);
        }
        this.transferCollectionBasicInfo(hbmAttributeInfo, target);
        target.setTargetEntity(StringHelper.isNotEmpty(hbmOneToMany.getClazz()) ? hbmOneToMany.getClazz() : hbmOneToMany.getEntityName());
        JaxbHbmKeyType key = hbmAttributeInfo.getKey();
        if (key != null) {
            target.setForeignKey(new JaxbForeignKey());
            if (StringHelper.isNotEmpty(key.getForeignKey())) {
                target.getForeignKey().setName(key.getForeignKey());
            }
        }
        target.setOrphanRemoval(this.isOrphanRemoval(hbmAttributeInfo.getCascade()));
        target.setCascade(this.convertCascadeType(hbmAttributeInfo.getCascade()));
    }

    private void transferManyToManyInfo(PluralAttributeInfo hbmCollection, JaxbHbmManyToManyCollectionElementType manyToMany, JaxbManyToMany target) {
        if (StringHelper.isNotEmpty(hbmCollection.getCollectionType())) {
            this.handleUnsupported("Collection-type is not supported for transformation", new Object[0]);
        }
        if (CollectionHelper.isNotEmpty(hbmCollection.getFilter())) {
            this.handleUnsupported("Filters are not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(hbmCollection.getWhere())) {
            this.handleUnsupported("SQL restrictions are not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlInsert() != null) {
            this.handleUnsupported("<sql-insert/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlUpdate() != null) {
            this.handleUnsupported("<sql-update/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlDelete() != null) {
            this.handleUnsupported("<sql-delete/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlDeleteAll() != null) {
            this.handleUnsupported("<sql-delete-all/> not supported for transformation", new Object[0]);
        }
        if (manyToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(manyToMany.getNode())) {
            this.handleUnsupported("`node` not supported for transformation", new Object[0]);
        }
        if (manyToMany.getNotFound() != JaxbHbmNotFoundEnum.EXCEPTION) {
            this.handleUnsupported("`not-found` not supported for transformation", new Object[0]);
        }
        this.transferCollectionBasicInfo(hbmCollection, target);
        target.setTargetEntity(StringHelper.isNotEmpty(manyToMany.getClazz()) ? manyToMany.getClazz() : manyToMany.getEntityName());
    }

    private void transferIdentifier(JaxbHbmRootEntityType source, JaxbEntity target) {
        if (source.getId() != null) {
            target.getAttributes().getId().add(this.convertSimpleId(source.getId()));
        } else {
            JaxbHbmCompositeIdType hbmCompositeId = source.getCompositeId();
            assert (hbmCompositeId != null);
            boolean isAggregate = StringHelper.isNotEmpty(hbmCompositeId.getClazz()) ? !hbmCompositeId.isMapped() : false;
            if (isAggregate) {
                target.getAttributes().setEmbeddedId(new JaxbEmbeddedId());
                target.getAttributes().getEmbeddedId().setName(hbmCompositeId.getName());
                target.getAttributes().getEmbeddedId().setAttributeAccessor(hbmCompositeId.getAccess());
                JaxbEmbeddable embeddable = new JaxbEmbeddable();
                embeddable.setClazz(hbmCompositeId.getClazz());
                embeddable.setAttributes(new JaxbEmbeddableAttributes());
                for (JaxbHbmToolingHintContainer hbmCompositeAttribute : hbmCompositeId.getKeyPropertyOrKeyManyToOne()) {
                    if (hbmCompositeAttribute instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                        JaxbHbmCompositeKeyBasicAttributeType keyProp = (JaxbHbmCompositeKeyBasicAttributeType)hbmCompositeAttribute;
                        JaxbBasic basic = new JaxbBasic();
                        basic.setName(keyProp.getName());
                        basic.setAttributeAccessor(keyProp.getAccess());
                        if (StringHelper.isNotEmpty(keyProp.getColumnAttribute())) {
                            JaxbColumn column = new JaxbColumn();
                            column.setName(keyProp.getColumnAttribute());
                            basic.setColumn(column);
                        } else {
                            for (JaxbHbmColumnType hbmColumn : keyProp.getColumn()) {
                                JaxbColumn column = new JaxbColumn();
                                this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(hbmColumn), new TargetColumnAdapterJaxbColumn(column, ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
                                basic.setColumn(column);
                            }
                        }
                        embeddable.getAttributes().getBasicAttributes().add(basic);
                        continue;
                    }
                    JaxbHbmCompositeKeyManyToOneType keyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmCompositeAttribute;
                    JaxbManyToOne manyToOne = this.transferManyToOneAttribute(keyManyToOne);
                    embeddable.getAttributes().getManyToOneAttributes().add(manyToOne);
                }
                this.ormRoot.getEmbeddables().add(embeddable);
            } else {
                JaxbIdClass idClass = new JaxbIdClass();
                idClass.setClazz(hbmCompositeId.getClazz());
                target.setIdClass(idClass);
                for (JaxbHbmToolingHintContainer hbmCompositeAttribute : hbmCompositeId.getKeyPropertyOrKeyManyToOne()) {
                    if (hbmCompositeAttribute instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                        JaxbHbmCompositeKeyBasicAttributeType keyProp = (JaxbHbmCompositeKeyBasicAttributeType)hbmCompositeAttribute;
                        JaxbId id = new JaxbId();
                        id.setName(keyProp.getName());
                        id.setAttributeAccessor(keyProp.getAccess());
                        if (StringHelper.isNotEmpty(keyProp.getColumnAttribute())) {
                            JaxbColumn column = new JaxbColumn();
                            column.setName(keyProp.getColumnAttribute());
                            id.setColumn(column);
                        } else if (keyProp.getColumn().size() == 1) {
                            id.setColumn(new JaxbColumn());
                            this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(keyProp.getColumn().get(0)), new TargetColumnAdapterJaxbColumn(id.getColumn(), ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
                        }
                        target.getAttributes().getId().add(id);
                        continue;
                    }
                    JaxbHbmCompositeKeyManyToOneType keyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmCompositeAttribute;
                    JaxbManyToOne manyToOne = this.transferManyToOneAttribute(keyManyToOne);
                    target.getAttributes().getManyToOneAttributes().add(manyToOne);
                }
            }
        }
    }

    private JaxbId convertSimpleId(JaxbHbmSimpleIdType source) {
        JaxbId target = new JaxbId();
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setUnsavedValue(source.getUnsavedValue());
        if (StringHelper.isNotEmpty(source.getColumnAttribute())) {
            target.setColumn(new JaxbColumn());
            target.getColumn().setName(source.getColumnAttribute());
        } else if (source.getColumn() != null && source.getColumn().size() == 1) {
            target.setColumn(new JaxbColumn());
            this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(source.getColumn().get(0)), new TargetColumnAdapterJaxbColumn(target.getColumn(), ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
        }
        return target;
    }

    private void transferNaturalIdentifiers(JaxbHbmRootEntityType source, JaxbEntity target) {
        if (source.getNaturalId() == null) {
            return;
        }
        final JaxbNaturalId naturalId = new JaxbNaturalId();
        this.transferAttributes(source.getNaturalId().getAttributes(), new AttributesContainer(){

            @Override
            public List<JaxbBasic> getBasicAttributes() {
                return naturalId.getBasic();
            }

            @Override
            public List<JaxbEmbedded> getEmbeddedAttributes() {
                return naturalId.getEmbedded();
            }

            @Override
            public List<JaxbOneToOne> getOneToOneAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToOne> getManyToOneAttributes() {
                return null;
            }

            @Override
            public List<JaxbHbmAnyMapping> getDiscriminatedAssociations() {
                return null;
            }

            @Override
            public List<JaxbElementCollection> getElementCollectionAttributes() {
                return null;
            }

            @Override
            public List<JaxbOneToMany> getOneToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToMany> getManyToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbHbmManyToAny> getPluralDiscriminatedAssociations() {
                return null;
            }

            @Override
            public List<JaxbTransient> getTransients() {
                return null;
            }
        });
        naturalId.setMutable(source.getNaturalId().isMutable());
        target.getAttributes().setNaturalId(naturalId);
    }

    private void transferVersion(JaxbHbmRootEntityType source, JaxbEntity target) {
        JaxbHbmVersionAttributeType hbmVersion = source.getVersion();
        if (hbmVersion != null) {
            JaxbVersion version = new JaxbVersion();
            version.setName(hbmVersion.getName());
            if (StringHelper.isNotEmpty(hbmVersion.getColumnAttribute())) {
                version.setColumn(new JaxbColumn());
                version.getColumn().setName(hbmVersion.getColumnAttribute());
            }
            target.getAttributes().getVersion().add(version);
        }
    }

    private void transferTimestamp(JaxbHbmRootEntityType source, JaxbEntity target) {
        JaxbHbmTimestampAttributeType hbmTimestamp = source.getTimestamp();
        if (hbmTimestamp != null) {
            JaxbVersion version = new JaxbVersion();
            version.setName(hbmTimestamp.getName());
            if (StringHelper.isNotEmpty(hbmTimestamp.getColumnAttribute())) {
                version.setColumn(new JaxbColumn());
                version.getColumn().setName(hbmTimestamp.getColumnAttribute());
            }
            version.setTemporal(TemporalType.TIMESTAMP);
            target.getAttributes().getVersion().add(version);
        }
    }

    private void transferJoins(JaxbHbmRootEntityType source, JaxbEntity target) {
        for (JaxbHbmSecondaryTableType hbmJoin : source.getJoin()) {
            if (!hbmJoin.isInverse()) {
                JaxbSecondaryTable secondaryTable = new JaxbSecondaryTable();
                secondaryTable.setCatalog(hbmJoin.getCatalog());
                secondaryTable.setComment(hbmJoin.getComment());
                secondaryTable.setName(hbmJoin.getTable());
                secondaryTable.setSchema(hbmJoin.getSchema());
                secondaryTable.setOptional(hbmJoin.isOptional());
                if (hbmJoin.getKey() != null) {
                    JaxbPrimaryKeyJoinColumn joinColumn = new JaxbPrimaryKeyJoinColumn();
                    joinColumn.setName(hbmJoin.getKey().getColumnAttribute());
                    secondaryTable.getPrimaryKeyJoinColumn().add(joinColumn);
                }
                target.getSecondaryTable().add(secondaryTable);
            }
            for (Serializable attributeMapping : hbmJoin.getAttributes()) {
                if (attributeMapping instanceof JaxbHbmBasicAttributeType) {
                    JaxbBasic prop = this.transformBasicAttribute((JaxbHbmBasicAttributeType)attributeMapping);
                    if (prop.getColumn() != null) {
                        prop.getColumn().setTable(hbmJoin.getTable());
                    }
                    target.getAttributes().getBasicAttributes().add(prop);
                    continue;
                }
                if (attributeMapping instanceof JaxbHbmCompositeAttributeType) {
                    throw new MappingException("transformation of <component/> as part of <join/> (secondary-table) not yet implemented", this.origin);
                }
                if (attributeMapping instanceof JaxbHbmManyToOneType) {
                    throw new MappingException("transformation of <many-to-one/> as part of <join/> (secondary-table) not yet implemented", this.origin);
                }
                if (attributeMapping instanceof JaxbHbmAnyAssociationType) {
                    throw new MappingException("transformation of <any/> as part of <join/> (secondary-table) not yet implemented", this.origin);
                }
                if (!(attributeMapping instanceof JaxbHbmDynamicComponentType)) continue;
                this.handleUnsupportedContent("<dynamic-component/> mappings not supported; skipping");
            }
        }
    }

    private JaxbManyToOne transferManyToOneAttribute(JaxbHbmCompositeKeyManyToOneType hbmM2O) {
        JaxbManyToOne m2o = new JaxbManyToOne();
        m2o.setId(true);
        m2o.setName(hbmM2O.getName());
        m2o.setAttributeAccessor(hbmM2O.getAccess());
        m2o.setFetch(this.convert(hbmM2O.getLazy()));
        m2o.setForeignKey(new JaxbForeignKey());
        m2o.getForeignKey().setName(hbmM2O.getForeignKey());
        if (!hbmM2O.getColumn().isEmpty()) {
            for (JaxbHbmColumnType hbmColumn : hbmM2O.getColumn()) {
                JaxbJoinColumn joinColumn = new JaxbJoinColumn();
                joinColumn.setName(hbmColumn.getName());
                joinColumn.setNullable(hbmColumn.isNotNull() == null ? null : Boolean.valueOf(hbmColumn.isNotNull() == false));
                joinColumn.setUnique(hbmColumn.isUnique());
                m2o.getJoinColumn().add(joinColumn);
            }
        } else {
            JaxbJoinColumn joinColumn = new JaxbJoinColumn();
            if (StringHelper.isEmpty(hbmM2O.getColumnAttribute())) {
                joinColumn.setName(hbmM2O.getName());
            } else {
                joinColumn.setName(hbmM2O.getColumnAttribute());
            }
            m2o.getJoinColumn().add(joinColumn);
        }
        if (StringHelper.isNotEmpty(hbmM2O.getEntityName())) {
            m2o.setTargetEntity(hbmM2O.getEntityName());
        } else {
            m2o.setTargetEntity(hbmM2O.getClazz());
        }
        if (hbmM2O.getOnDelete() != null) {
            m2o.setOnDelete(this.convert(hbmM2O.getOnDelete()));
        }
        return m2o;
    }

    private void transferUnionSubclass(JaxbHbmUnionSubclassEntityType hbmSubclass, JaxbEntity subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of union-subclass entity `%` - `%s`", (Object)this.extractEntityName(hbmSubclass), (Object)this.origin);
        subclassEntity.setProxy(hbmSubclass.getProxy());
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
        subclassEntity.setTable(new JaxbTable());
        subclassEntity.getTable().setCatalog(hbmSubclass.getCatalog());
        subclassEntity.getTable().setSchema(hbmSubclass.getSchema());
        subclassEntity.getTable().setName(hbmSubclass.getTable());
        subclassEntity.getTable().setComment(hbmSubclass.getComment());
        subclassEntity.getTable().setCheck(hbmSubclass.getCheck());
        if (!hbmSubclass.getUnionSubclass().isEmpty()) {
            subclassEntity.setInheritance(new JaxbInheritance());
            subclassEntity.getInheritance().setStrategy(InheritanceType.TABLE_PER_CLASS);
            for (JaxbHbmUnionSubclassEntityType nestedHbmSubclass : hbmSubclass.getUnionSubclass()) {
                JaxbEntity nestedSubclassEntity = new JaxbEntity();
                this.ormRoot.getEntities().add(nestedSubclassEntity);
                this.transferUnionSubclass(nestedHbmSubclass, nestedSubclassEntity);
            }
        }
    }

    private void transferFetchable(JaxbHbmLazyWithNoProxyEnum hbmLazy, JaxbHbmFetchStyleEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, Boolean constrained, ToOneAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbSingularFetchMode fetch = JaxbSingularFetchMode.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.FALSE)) {
                laziness = FetchType.EAGER;
            } else if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.NO_PROXY)) {
                // empty if block
            }
        }
        if (constrained != null && !constrained.booleanValue()) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchMode.JOIN;
        } else if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbSingularFetchMode.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchMode.JOIN;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private void transferFetchable(JaxbHbmLazyWithExtraEnum hbmLazy, JaxbHbmFetchStyleWithSubselectEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, CollectionAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbPluralFetchMode fetch = JaxbPluralFetchMode.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.EXTRA)) {
                throw new MappingException("HBM transformation: extra lazy not yet supported.", this.origin);
            }
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.FALSE)) {
                laziness = FetchType.EAGER;
            }
        }
        if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbPluralFetchMode.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbPluralFetchMode.JOIN;
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.SUBSELECT)) {
            fetch = JaxbPluralFetchMode.SUBSELECT;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private FetchType convert(JaxbHbmLazyEnum hbmLazy) {
        if (hbmLazy != null && "false".equalsIgnoreCase(hbmLazy.value())) {
            return FetchType.EAGER;
        }
        return FetchType.LAZY;
    }

    private OnDeleteAction convert(JaxbHbmOnDeleteEnum hbmOnDelete) {
        return hbmOnDelete == JaxbHbmOnDeleteEnum.CASCADE ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    private JaxbHbmFilter convert(JaxbHbmFilterType hbmFilter) {
        JaxbHbmFilter filter = new JaxbHbmFilter();
        filter.setName(hbmFilter.getName());
        boolean shouldAutoInjectAliases = hbmFilter.getAutoAliasInjection() == null || hbmFilter.getAutoAliasInjection().equalsIgnoreCase("true");
        filter.setAutoAliasInjection(shouldAutoInjectAliases);
        filter.setCondition(hbmFilter.getCondition());
        for (Serializable content : hbmFilter.getContent()) {
            if (content instanceof String) {
                filter.setCondition((String)((Object)content));
                continue;
            }
            JaxbHbmFilterAliasMappingType hbmAliasMapping = (JaxbHbmFilterAliasMappingType)content;
            JaxbHbmFilter.JaxbAliases aliasMapping = new JaxbHbmFilter.JaxbAliases();
            aliasMapping.setAlias(hbmAliasMapping.getAlias());
            aliasMapping.setEntity(hbmAliasMapping.getEntity());
            aliasMapping.setTable(hbmAliasMapping.getTable());
            filter.getContent().add(aliasMapping);
        }
        return filter;
    }

    private JaxbCascadeType convertCascadeType(String s) {
        JaxbCascadeType cascadeType = new JaxbCascadeType();
        if (StringHelper.isNotEmpty(s)) {
            String[] split;
            s = s.toLowerCase(Locale.ROOT).replaceAll(" ", "");
            for (String hbmCascade : split = s.split(",")) {
                if (hbmCascade.contains("all")) {
                    cascadeType.setCascadeAll(new JaxbEmptyType());
                }
                if (hbmCascade.contains("persist")) {
                    cascadeType.setCascadePersist(new JaxbEmptyType());
                }
                if (hbmCascade.contains("merge")) {
                    cascadeType.setCascadeMerge(new JaxbEmptyType());
                }
                if (hbmCascade.contains("refresh")) {
                    cascadeType.setCascadeRefresh(new JaxbEmptyType());
                }
                if (hbmCascade.contains("save-update")) {
                    cascadeType.setCascadeSaveUpdate(new JaxbEmptyType());
                }
                if (hbmCascade.contains("evict") || hbmCascade.contains("detach")) {
                    cascadeType.setCascadeDetach(new JaxbEmptyType());
                }
                if (hbmCascade.contains("replicate")) {
                    cascadeType.setCascadeReplicate(new JaxbEmptyType());
                }
                if (hbmCascade.contains("lock")) {
                    cascadeType.setCascadeLock(new JaxbEmptyType());
                }
                if (!hbmCascade.contains("delete")) continue;
                cascadeType.setCascadeDelete(new JaxbEmptyType());
            }
        }
        return cascadeType;
    }

    private boolean isOrphanRemoval(String s) {
        return StringHelper.isNotEmpty(s) && s.toLowerCase(Locale.ROOT).contains("orphan");
    }

    private String getFullyQualifiedClassName(String className) {
        String defaultPackageName = this.ormRoot.getPackage();
        if (StringHelper.isNotEmpty(className) && className.indexOf(46) < 0 && StringHelper.isNotEmpty(defaultPackageName)) {
            className = StringHelper.qualify(defaultPackageName, className);
        }
        return className;
    }

    public static interface Options {
        public UnsupportedFeatureHandling unsupportedFeatureHandling();
    }
}

