/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Struct;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AggregateComponentSecondPass;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public final class AggregateComponentBinder {
    private AggregateComponentBinder() {
    }

    public static void processAggregate(Component component, PropertyHolder propertyHolder, PropertyData inferredData, XClass componentXClass, AnnotatedColumns columns, MetadataBuildingContext context) {
        if (AggregateComponentBinder.isAggregate(inferredData.getProperty(), componentXClass)) {
            InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
            TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
            QualifiedName structQualifiedName = AggregateComponentBinder.determineStructName(columns, inferredData, componentXClass, context);
            String structName = structQualifiedName == null ? null : structQualifiedName.render();
            typeConfiguration.getJavaTypeRegistry().resolveDescriptor(component.getComponentClass(), () -> new EmbeddableAggregateJavaType(component.getComponentClass(), structName));
            component.setStructName(structQualifiedName);
            component.setStructColumnNames(AggregateComponentBinder.determineStructAttributeNames(inferredData, componentXClass));
            BasicValueBinder basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, component, context);
            basicValueBinder.setPropertyName(inferredData.getPropertyName());
            basicValueBinder.setReturnedClassName(inferredData.getPropertyClass().getName());
            basicValueBinder.setColumns(columns);
            basicValueBinder.setPersistentClassName(propertyHolder.getClassName());
            basicValueBinder.setType(inferredData.getProperty(), inferredData.getPropertyClass(), inferredData.getDeclaringClass().getName(), null);
            BasicValue propertyValue = basicValueBinder.make();
            AggregateColumn aggregateColumn = (AggregateColumn)propertyValue.getColumn();
            if (structName != null && aggregateColumn.getSqlType() == null) {
                if (inferredData.getProperty().isArray() || inferredData.getProperty().isCollection()) {
                    aggregateColumn.setSqlTypeCode(AggregateComponentBinder.getStructPluralSqlTypeCode(context));
                    aggregateColumn.setSqlType(context.getMetadataCollector().getDatabase().getDialect().getArrayTypeName(null, structName, null));
                } else {
                    aggregateColumn.setSqlTypeCode(2002);
                    aggregateColumn.setSqlType(structName);
                }
            }
            component.setAggregateColumn(aggregateColumn);
            context.getMetadataCollector().addSecondPass(new AggregateComponentSecondPass(propertyHolder, component, componentXClass, inferredData.getPropertyName(), context));
        }
    }

    private static int getStructPluralSqlTypeCode(MetadataBuildingContext context) {
        int arrayTypeCode = context.getPreferredSqlTypeCodeForArray();
        switch (arrayTypeCode) {
            case 2003: {
                return 3016;
            }
            case 4000: {
                return 3017;
            }
        }
        throw new UnsupportedOperationException("Dialect does not support structured array types: " + context.getMetadataCollector().getDatabase().getDialect().getClass().getName());
    }

    private static QualifiedName determineStructName(AnnotatedColumns columns, PropertyData inferredData, XClass returnedClassOrElement, MetadataBuildingContext context) {
        Struct struct;
        XProperty property = inferredData.getProperty();
        if (property != null) {
            String sqlType;
            List<AnnotatedColumn> columnList;
            struct = property.getAnnotation(Struct.class);
            if (struct != null) {
                return AggregateComponentBinder.toQualifiedName(struct, context);
            }
            JdbcTypeCode jdbcTypeCode = property.getAnnotation(JdbcTypeCode.class);
            if (jdbcTypeCode != null && (jdbcTypeCode.value() == 2002 || jdbcTypeCode.value() == 3016 || jdbcTypeCode.value() == 3017) && columns != null && (columnList = columns.getColumns()).size() == 1 && (sqlType = columnList.get(0).getSqlType()) != null) {
                if (sqlType.contains(".")) {
                    return QualifiedNameParser.INSTANCE.parse(sqlType);
                }
                return new QualifiedNameParser.NameParts(null, null, context.getMetadataCollector().getDatabase().toIdentifier(sqlType));
            }
        }
        if ((struct = returnedClassOrElement.getAnnotation(Struct.class)) != null) {
            return AggregateComponentBinder.toQualifiedName(struct, context);
        }
        return null;
    }

    private static QualifiedName toQualifiedName(Struct struct, MetadataBuildingContext context) {
        Database database = context.getMetadataCollector().getDatabase();
        return new QualifiedNameImpl(database.toIdentifier(struct.catalog()), database.toIdentifier(struct.schema()), database.toIdentifier(struct.name()));
    }

    private static String[] determineStructAttributeNames(PropertyData inferredData, XClass returnedClassOrElement) {
        Struct struct;
        XProperty property = inferredData.getProperty();
        if (property != null && (struct = property.getAnnotation(Struct.class)) != null) {
            return struct.attributes();
        }
        struct = returnedClassOrElement.getAnnotation(Struct.class);
        if (struct != null) {
            return struct.attributes();
        }
        return null;
    }

    private static boolean isAggregate(XProperty property, XClass returnedClass) {
        if (property != null) {
            Struct struct = property.getAnnotation(Struct.class);
            if (struct != null) {
                return true;
            }
            JdbcTypeCode jdbcTypeCode = property.getAnnotation(JdbcTypeCode.class);
            if (jdbcTypeCode != null) {
                switch (jdbcTypeCode.value()) {
                    case 2002: 
                    case 2009: 
                    case 3001: 
                    case 3016: 
                    case 3017: 
                    case 3018: 
                    case 3019: {
                        return true;
                    }
                }
            }
        }
        if (returnedClass != null) {
            return returnedClass.isAnnotationPresent(Struct.class);
        }
        return false;
    }
}

