/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.AltibaseSqlAstTranslator;
import org.hibernate.community.dialect.pagination.AltibaseLimitHandler;
import org.hibernate.community.dialect.sequence.AltibaseSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorAltibaseDatabaseImpl;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.OracleTruncFunction;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class AltibaseDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(7, 1);

    public AltibaseDialect() {
        this(MINIMUM_VERSION);
    }

    public AltibaseDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION));
        this.registerKeywords(info);
    }

    public AltibaseDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "char(1)";
            }
            case 6: 
            case 8: {
                return "double";
            }
            case -6: {
                return "smallint";
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return "date";
            }
            case -2: {
                return "byte($l)";
            }
            case -3: {
                return "varbyte($l)";
            }
            case -4: {
                return "blob";
            }
            case -7: {
                return "varbit($l)";
            }
            case -1: 
            case 2011: {
                return "clob";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, this.columnType(-4), this).withTypeCapacity(this.getMaxVarbinaryLength(), this.columnType(-2)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-7, this.columnType(-4), this).withTypeCapacity(64000L, this.columnType(-7)).build());
    }

    @Override
    public int getMaxVarcharLength() {
        return 32000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 32000;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        switch (specification) {
            case BOTH: {
                return isWhitespace ? "trim(?1)" : "trim(?1,?2)";
            }
            case LEADING: {
                return isWhitespace ? "ltrim(?1)" : "ltrim(?1,?2)";
            }
            case TRAILING: {
                return isWhitespace ? "rtrim(?1)" : "rtrim(?1,?2)";
            }
        }
        return super.trimPattern(specification, isWhitespace);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ceiling_ceil();
        functionFactory.trim2();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.char_chr();
        functionFactory.concat_pipeOperator();
        functionFactory.coalesce();
        functionFactory.initcap();
        functionFactory.repeat_rpad();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionFactory.ascii();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.lastDay();
        functionFactory.sysdate();
        functionFactory.rownum();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.translate();
        functionFactory.addMonths();
        functionFactory.listagg(null);
        functionFactory.monthsBetween();
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.bitLength_pattern("bit_length(?1)", "lengthb(?1)*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "lengthb(?1)");
        functionContributions.getFunctionRegistry().register("trunc", new OracleTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitand", "numand(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitor", "numor(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "numxor(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    @Override
    public String currentDate() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTime() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestamp() {
        return "sysdate";
    }

    @Override
    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    @Override
    public String currentLocalTimestamp() {
        return "trunc(sysdate,'second')";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new AltibaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "extract(?2, 'DAYOFWEEK')";
            }
            case DAY_OF_MONTH: {
                return "extract(?2, 'DAY')";
            }
            case DAY_OF_YEAR: {
                return "extract(?2,'DAYOFYEAR')";
            }
            case WEEK: {
                return "to_number(to_char(?2,'IW'))";
            }
            case WEEK_OF_YEAR: {
                return "extract(?2, 'WEEK')";
            }
            case EPOCH: {
                return this.timestampdiffPattern(TemporalUnit.SECOND, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP).replace("?2", "TO_DATE('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')").replace("?3", "?2");
            }
            case QUARTER: {
                return "extract(?2, 'QUARTER')";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd(MICROSECOND,(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd(SECOND, ?2, ?3)";
            }
        }
        return "timestampadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NATIVE: 
            case SECOND: {
                return "datediff(?2, ?3, 'SECOND')";
            }
            case NANOSECOND: {
                return "datediff(?2, ?3, 'MICROSECOND')*1e3";
            }
        }
        return "datediff(?2, ?3, '?1')";
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("VARBYTE'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).result());
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger(from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean(from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean(from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: 
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean(from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: 
                    case TF_BOOLEAN: 
                    case YN_BOOLEAN: {
                        return BooleanDecoder.toString(from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: 
                    case OFFSET_TIMESTAMP: 
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF6')";
                    }
                }
                break;
            }
            case CLOB: {
                return "cast(?1 as varchar(32000))";
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: 
            case OFFSET_TIMESTAMP: 
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD HH24:MI:SS.FF6')";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP) {
            appender.appendSql("{ts '");
            DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
            appender.appendSql("'}");
            return;
        }
        super.appendDateTimeLiteral(appender, temporalAccessor, precision, jdbcTimeZone);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP) {
            appender.appendSql("{ts '");
            DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
            appender.appendSql("'}");
            return;
        }
        super.appendDateTimeLiteral(appender, date, precision, jdbcTimeZone);
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        if (unit == TemporalUnit.NATIVE) {
            return "microsecond";
        }
        return super.translateDurationField(unit);
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.LAST;
    }

    @Override
    public String getAddColumnString() {
        return "add column (";
    }

    @Override
    public String getAddColumnSuffixString() {
        return ")";
    }

    @Override
    public int getMaxIdentifierLength() {
        return 40;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteKeywords(true);
        builder.setAutoQuoteInitialUnderscore(false);
        builder.applyReservedWords(dbMetaData);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsTruncateWithCast() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return AltibaseSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "SELECT a.user_name USER_NAME, b.table_name SEQUENCE_NAME, c.current_seq CURRENT_VALUE, c.start_seq START_VALUE, c.min_seq MIN_VALUE, c.max_seq MAX_VALUE, c.increment_seq INCREMENT_BY, c.flag CYCLE_, c.sync_interval CACHE_SIZE FROM system_.sys_users_ a, system_.sys_tables_ b, x$seq c WHERE a.user_id = b.user_id AND b.table_oid = c.seq_oid AND a.user_name <> 'SYSTEM_' AND b.table_type = 'S' ORDER BY 1,2";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorAltibaseDatabaseImpl.INSTANCE;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return AltibaseLimitHandler.INSTANCE;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public boolean supportsTemporaryTables() {
        return false;
    }

    @Override
    public boolean supportsTemporaryTablePrimaryKey() {
        return false;
    }

    @Override
    protected boolean supportsPredicateAsExpression() {
        return false;
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
                case 4164: 
                case 334393: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 69720: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
                case 200820: 
                case 200822: 
                case 200823: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public String getDual() {
        return "dual";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }
}

