/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DerbyLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public DerbyLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        if (DerbyLegacySqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.appendSql("delete from ");
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.DELETE);
                super.renderDmlTargetTableExpression(statement.getTargetTable());
                this.append(" dml_target_");
            }
            finally {
                clauseStack.pop();
            }
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement, "dml_target_"));
            this.visitReturningColumns(statement.getReturningColumns());
        } else {
            super.visitDeleteStatementOnly(statement);
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (DerbyLegacySqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.appendSql("update ");
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.UPDATE);
                super.renderDmlTargetTableExpression(statement.getTargetTable());
                this.append(" dml_target_");
            }
            finally {
                clauseStack.pop();
            }
            this.renderSetClause(statement.getAssignments());
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement, "dml_target_"));
            this.visitReturningColumns(statement.getReturningColumns());
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    @Override
    protected void visitSetAssignment(Assignment assignment) {
        UpdateStatement statement;
        Statement currentStatement = this.getStatementStack().getCurrent();
        if (currentStatement instanceof UpdateStatement && DerbyLegacySqlAstTranslator.hasNonTrivialFromClause((statement = (UpdateStatement)currentStatement).getFromClause())) {
            this.visitSetAssignmentEmulateJoin(assignment, statement);
        } else {
            super.visitSetAssignment(assignment);
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected boolean supportsWithClause() {
        return false;
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected String getForUpdate() {
        return " for update";
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        return " for read only";
    }

    @Override
    protected String getForUpdateWithClause() {
        return " with rs";
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (this.supportsOffsetFetchClause()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else if (!this.getClauseStack().isEmpty()) {
            throw new IllegalArgumentException("Can't render offset and fetch clause for subquery");
        }
    }

    @Override
    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        List<Expression> listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=" + (inListPredicate.isNegated() ? "1" : "0"));
            return;
        }
        Expression testExpression = inListPredicate.getTestExpression();
        if (this.isParameter(testExpression)) {
            this.renderCasted(testExpression);
            if (inListPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in (");
            this.renderCommaSeparated(listExpressions);
            this.appendSql(')');
        } else {
            super.visitInListPredicate(inListPredicate);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean needsRowsToSkip() {
        return !this.supportsOffsetFetchClause();
    }

    @Override
    protected boolean needsMaxRows() {
        return !this.supportsOffsetFetchClause();
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion().isSameOrAfter(10, 6);
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(10, 5);
    }

    @Override
    protected boolean supportsJoinInMutationStatementSubquery() {
        return false;
    }

    @Override
    protected void visitArithmeticOperand(Expression expression) {
        this.render(expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }
}

