/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.MimerSQLSqlAstTranslator;
import org.hibernate.community.dialect.identity.MimerSQLIdentityColumnSupport;
import org.hibernate.community.dialect.sequence.MimerSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorMimerSQLDatabaseImpl;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.sql.internal.BinaryFloatDdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MimerSQLDialect
extends Dialect {
    public MimerSQLDialect() {
        super(DatabaseVersion.make(11));
    }

    public MimerSQLDialect(DialectResolutionInfo info) {
        super(info);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "integer(3)";
            }
            case 2014: {
                return this.columnType(93);
            }
            case 1: {
                return this.columnType(-15);
            }
            case 12: {
                return this.columnType(-9);
            }
            case 4001: {
                return this.columnType(4002);
            }
            case 2004: {
                return "blob(2G)";
            }
            case 2005: 
            case 2011: {
                return "nclob(2G)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new BinaryFloatDdlType(this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(12, this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4001), "nvarchar(" + this.getMaxNVarcharLength() + ")", (Dialect)this).withTypeCapacity(this.getMaxNVarcharLength(), this.columnType(12)).build());
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 15000;
    }

    @Override
    public int getMaxVarcharLength() {
        return 15000;
    }

    @Override
    public int getMaxNVarcharLength() {
        return 5000;
    }

    @Override
    public DatabaseVersion getVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 50;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.trunc_truncate();
        functionFactory.repeat();
        functionFactory.pad_repeat();
        functionFactory.dayofweekmonthyear();
        functionFactory.concat_pipeOperator();
        functionFactory.position();
        functionFactory.localtimeLocaltimestamp();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MimerSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("cast((?3-?2) ");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: 
            case SECOND: {
                pattern.append("second(12,9)");
                break;
            }
            case MINUTE: {
                pattern.append("minute(10)");
                break;
            }
            case HOUR: {
                pattern.append("hour(8)");
                break;
            }
            case WEEK: 
            case DAY: {
                pattern.append("day(7)");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("month(7)");
                break;
            }
            case YEAR: {
                pattern.append("year(7)");
                break;
            }
            default: {
                throw new SemanticException("unsupported duration unit: " + unit);
            }
        }
        pattern.append(" as bigint)");
        switch (unit) {
            case WEEK: {
                pattern.append("/7");
                break;
            }
            case QUARTER: {
                pattern.append("/3");
                break;
            }
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("*1e9");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                return "(?3+(?2)/1e9*interval '1' second)";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3' month)";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7' day)";
            }
        }
        return "(?3+(?2)*interval '1' ?1)";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return MimerSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.ext_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorMimerSQLDatabaseImpl.INSTANCE;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Mimer SQL");
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public boolean useConnectionToCreateLob() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return MimerSQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }
}

