/*
 * Decompiled with CFR 0.152.
 */
package repository;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.account.Exceptions.AccountAlreadyExist;
import BlockDynasty.Economy.domain.entities.account.Exceptions.AccountNotFoundException;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.RepositoryException;
import BlockDynasty.Economy.domain.persistence.entities.IAccountRepository;
import BlockDynasty.Economy.domain.persistence.entities.ICurrencyRepository;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.persistence.transaction.ITransactions;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.result.TransferResult;
import java.math.BigDecimal;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import repository.AccountRepository;
import repository.ConnectionHandler.Hibernate.Connection;
import repository.CurrencyRepository;
import repository.TransactionRepository;

public class Repository
implements IRepository {
    private Connection connection;
    private final SessionFactory sessionFactory;
    private IAccountRepository accountRepository;
    private ICurrencyRepository currencyRepository;
    private ITransactions transactionsRepository;

    public Repository(Connection connection) {
        this.connection = connection;
        this.sessionFactory = connection.getSession();
        this.accountRepository = new AccountRepository(this.sessionFactory);
        this.currencyRepository = new CurrencyRepository(this.sessionFactory);
        this.transactionsRepository = new TransactionRepository(this.sessionFactory);
    }

    @Override
    public List<Currency> loadCurrencies() {
        return this.currencyRepository.findAll();
    }

    @Override
    public Result<Currency> loadCurrencyByName(String name) {
        try {
            Currency currency = this.currencyRepository.findByName(name);
            return Result.success(currency);
        }
        catch (CurrencyNotFoundException e) {
            return Result.failure("Currency with name " + name + " not found.", ErrorCode.CURRENCY_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error loading currency: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public Result<Currency> loadCurrencyByUuid(String uuid) {
        try {
            Currency currency = this.currencyRepository.findByUuid(uuid);
            return Result.success(currency);
        }
        catch (CurrencyNotFoundException e) {
            return Result.failure("Currency with UUID " + uuid + " not found.", ErrorCode.CURRENCY_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error loading currency: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public Result<Currency> loadDefaultCurrency() {
        try {
            Currency currency = this.currencyRepository.findDefaultCurrency();
            return Result.success(currency);
        }
        catch (CurrencyNotFoundException e) {
            return Result.failure("Default currency not found.", ErrorCode.CURRENCY_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error loading default currency: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public void saveCurrency(Currency currency) {
        try {
            this.currencyRepository.save(currency);
        }
        catch (CurrencyNotFoundException e) {
            this.currencyRepository.create(currency);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving currency: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteCurrency(Currency currency) {
        try {
            this.currencyRepository.delete(currency);
        }
        catch (CurrencyNotFoundException currencyNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Account> loadAccounts() {
        return this.accountRepository.findAll();
    }

    @Override
    public Result<Account> loadAccountByUuid(String uuid) {
        try {
            Account account = this.accountRepository.findByUuid(uuid);
            return Result.success(account);
        }
        catch (AccountNotFoundException e) {
            return Result.failure("Account with UUID " + uuid + " not found.", ErrorCode.ACCOUNT_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error loading account: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public Result<Account> loadAccountByName(String name) {
        try {
            Account account = this.accountRepository.findByNickname(name);
            return Result.success(account);
        }
        catch (AccountNotFoundException e) {
            return Result.failure("Account with name " + name + " not found.", ErrorCode.ACCOUNT_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error loading account: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public void createAccount(Account account) {
        try {
            this.accountRepository.create(account);
        }
        catch (AccountAlreadyExist accountAlreadyExist) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveAccount(Account account) {
        try {
            this.accountRepository.save(account);
        }
        catch (AccountNotFoundException e) {
            this.accountRepository.create(account);
        }
        catch (Exception e) {
            throw new RepositoryException("Error saving account: " + e.getMessage(), e);
        }
    }

    @Override
    public Result<Void> deleteAccount(Account account) {
        try {
            this.accountRepository.delete(account);
            return Result.success(null);
        }
        catch (AccountNotFoundException e) {
            return Result.failure("Account with UUID " + String.valueOf(account.getUuid()) + " not found.", ErrorCode.ACCOUNT_NOT_FOUND);
        }
        catch (Exception e) {
            return Result.failure("Error deleting account: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
        }
    }

    @Override
    public List<Account> getAccountsTopByCurrency(String currencyName, int limit, int offset) {
        return this.accountRepository.getAccountsTopByCurrency(currencyName, limit, offset);
    }

    @Override
    public boolean isTopSupported() {
        return true;
    }

    @Override
    public String getName() {
        return "mysql";
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void clearAll() {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                session.createQuery("DELETE FROM BalanceDb").executeUpdate();
                session.createQuery("DELETE FROM AccountDb").executeUpdate();
                session.createQuery("DELETE FROM WalletDb").executeUpdate();
                session.createQuery("DELETE FROM CurrencyDb").executeUpdate();
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error clearing database: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public Result<TransferResult> transfer(String fromUuid, String toUuid, Currency currency, BigDecimal amount) {
        return this.transactionsRepository.transfer(fromUuid, toUuid, currency, amount);
    }

    @Override
    public Result<Account> withdraw(String accountUuid, Currency currency, BigDecimal amount) {
        return this.transactionsRepository.withdraw(accountUuid, currency, amount);
    }

    @Override
    public Result<Account> deposit(String accountUuid, Currency currency, BigDecimal amount) {
        return this.transactionsRepository.deposit(accountUuid, currency, amount);
    }

    @Override
    public Result<Account> exchange(String fromUuid, Currency fromCurrency, BigDecimal amountFrom, Currency toCurrency, BigDecimal amountTo) {
        return this.transactionsRepository.exchange(fromUuid, fromCurrency, amountFrom, toCurrency, amountTo);
    }

    @Override
    public Result<TransferResult> trade(String fromUuid, String toUuid, Currency fromCurrency, Currency toCurrency, BigDecimal amountFrom, BigDecimal amountTo) {
        return this.transactionsRepository.trade(fromUuid, toUuid, fromCurrency, toCurrency, amountFrom, amountTo);
    }

    @Override
    public Result<Account> setBalance(String accountUuid, Currency currency, BigDecimal amount) {
        return this.transactionsRepository.setBalance(accountUuid, currency, amount);
    }
}

