/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.services;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AccountService
implements IAccountService {
    private final IRepository dataStore;
    private final ICurrencyService currencyService;
    private final Map<String, List<Account>> accountsTopList;
    private final Map<UUID, Account> accountsOnlineUuid;
    private final Map<String, Account> accountsOnlineName;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final int expireCacheTopMinutes;

    public AccountService(int expireCacheTopMinutes, IRepository dataStore, ICurrencyService currencyService) {
        this.currencyService = currencyService;
        this.dataStore = dataStore;
        this.accountsOnlineUuid = new HashMap<UUID, Account>();
        this.accountsOnlineName = new HashMap<String, Account>();
        this.accountsTopList = new HashMap<String, List<Account>>();
        this.expireCacheTopMinutes = expireCacheTopMinutes;
        this.startClearingTask();
    }

    @Override
    public void addAccountToOnline(Account account) {
        this.accountsOnlineUuid.put(account.getUuid(), account);
        this.accountsOnlineName.put(account.getNickname(), account);
    }

    @Override
    public void removeAccountOnline(UUID uuid) {
        Account account = this.accountsOnlineUuid.remove(uuid);
        if (account != null) {
            this.accountsOnlineName.remove(account.getNickname());
        }
    }

    @Override
    public void removeAccountOnline(String name) {
        Account account = this.accountsOnlineName.remove(name);
        if (account != null) {
            this.accountsOnlineUuid.remove(account.getUuid());
        }
    }

    @Override
    public List<Account> getAccountsOffline() {
        return this.dataStore.loadAccounts();
    }

    @Override
    public List<Account> getAccountsOnline() {
        return new ArrayList<Account>(this.accountsOnlineUuid.values());
    }

    public Account getAccountOffline(String name) {
        return this.dataStore.loadAccountByName(name).getValue();
    }

    public Account getAccountOffline(UUID uuid) {
        return this.dataStore.loadAccountByUuid(uuid.toString()).getValue();
    }

    @Override
    public Account getAccountOnline(String name) {
        return this.accountsOnlineName.getOrDefault(name, null);
    }

    @Override
    public Account getAccountOnline(UUID uuid) {
        return this.accountsOnlineUuid.getOrDefault(uuid, null);
    }

    @Override
    public Account getAccount(String name) {
        Account account = this.getAccountOnline(name);
        if (account == null && (account = this.getAccountOffline(name)) != null) {
            this.syncWalletWithSystemCurrencies(account);
        }
        return account;
    }

    @Override
    public Account getAccount(UUID uuid) {
        Account account = this.getAccountOnline(uuid);
        if (account == null && (account = this.getAccountOffline(uuid)) != null) {
            this.syncWalletWithSystemCurrencies(account);
        }
        return account;
    }

    @Override
    public void syncOnlineAccount(Account account) {
        UUID uuid = account.getUuid();
        Account cachedAccount = this.getAccountOnline(uuid);
        if (cachedAccount != null) {
            for (Money updatedMoney : account.getBalances()) {
                Money cachedMoney = cachedAccount.getMoney(updatedMoney.getCurrency());
                if (cachedMoney != null) {
                    cachedMoney.setAmount(updatedMoney.getAmount());
                    continue;
                }
                cachedAccount.getBalances().add(new Money(updatedMoney.getCurrency(), updatedMoney.getAmount()));
            }
        }
    }

    @Override
    public void syncOnlineAccount(UUID uuid) {
        Result<Account> result;
        Account accountCache = this.getAccountOnline(uuid);
        if (accountCache != null && (result = this.dataStore.loadAccountByUuid(uuid.toString())).isSuccess()) {
            this.syncWalletWithSystemCurrencies(result.getValue());
            accountCache.setBalances(result.getValue().getBalances());
            accountCache.setBlocked(result.getValue().isBlocked());
            accountCache.setCanReceiveCurrency(result.getValue().canReceiveCurrency());
        }
    }

    @Override
    public void syncDbWithOnlineAccounts() {
        List<Account> accounts = this.getAccountsOnline();
        for (Account account : accounts) {
            this.syncWalletWithSystemCurrencies(account);
            try {
                this.dataStore.saveAccount(account);
            }
            catch (TransactionException e) {
                throw new TransactionException("Error in transaction", e);
            }
        }
    }

    private void syncWalletWithSystemCurrencies(Account account) {
        List<Money> updatedMonies = this.currencyService.getCurrencies().stream().map(systemCurrency -> account.getBalances().stream().filter(balance -> balance.getCurrency().getUuid().equals(systemCurrency.getUuid())).findFirst().orElseGet(() -> new Money((Currency)systemCurrency))).collect(Collectors.toList());
        account.setBalances(updatedMonies);
    }

    @Override
    public Result<Void> checkNameChange(Account account, String newName) {
        if (!account.getNickname().equalsIgnoreCase(newName)) {
            account.setNickname(newName);
            try {
                this.dataStore.saveAccount(account);
            }
            catch (TransactionException e) {
                return Result.failure("Error saving account after name change", ErrorCode.DATA_BASE_ERROR);
            }
        }
        return Result.success(null);
    }

    @Override
    public Result<Void> checkUuidChange(Account account, UUID newUuid) {
        if (!account.getUuid().equals(newUuid)) {
            account.setUuid(newUuid);
            try {
                this.dataStore.saveAccount(account);
            }
            catch (TransactionException e) {
                return Result.failure("Error saving account after UUID change", ErrorCode.DATA_BASE_ERROR);
            }
        }
        return Result.success(null);
    }

    @Override
    public void addAccountToTopList(Account account, String currencyName) {
        List accounts = this.accountsTopList.computeIfAbsent(currencyName, k -> new ArrayList());
        accounts.add(account);
    }

    @Override
    public List<Account> getAccountsTopList(String currency) {
        return this.accountsTopList.getOrDefault(currency, new ArrayList());
    }

    @Override
    public void clearTopList() {
        this.accountsTopList.clear();
    }

    private void startClearingTask() {
        this.scheduler.scheduleAtFixedRate(this::clearTopList, 0L, this.expireCacheTopMinutes, TimeUnit.MINUTES);
    }
}

