/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.services;

import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CurrencyService
implements ICurrencyService {
    private List<Currency> currencies;
    private IRepository repository;
    public Currency defaultCurrency;

    public CurrencyService(IRepository repository) {
        this.repository = repository;
        this.currencies = new ArrayList<Currency>();
        this.currencies = repository.loadCurrencies();
        if (this.currencies.isEmpty()) {
            Currency defaultCurrency = new Currency(UUID.randomUUID(), "Money", "Money");
            defaultCurrency.setColor("GREEN");
            defaultCurrency.setDefaultCurrency(true);
            repository.saveCurrency(defaultCurrency);
            this.currencies.add(defaultCurrency);
        }
        this.updateDefaultCurrency();
    }

    @Override
    public void syncCurrency(UUID uuid) {
        Result<Currency> result = this.repository.loadCurrencyByUuid(uuid.toString());
        if (!result.isSuccess()) {
            return;
        }
        this.currencies.removeIf(currency -> currency.getUuid().equals(uuid));
        this.currencies.add(result.getValue());
    }

    @Override
    public void add(Currency currency) {
        if (this.currencies.contains(currency)) {
            return;
        }
        this.currencies.add(currency);
    }

    @Override
    public void add(List<Currency> currencyList) {
        this.currencies.addAll(currencyList);
    }

    @Override
    public void remove(Currency currency) {
        this.currencies.remove(currency);
    }

    @Override
    public List<Currency> getCurrencies() {
        return this.currencies;
    }

    @Override
    public Currency getCurrency(String name) {
        return this.currencies.stream().filter(currency -> currency.getSingular().equalsIgnoreCase(name) || currency.getPlural().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public Currency getCurrency(UUID uuid) {
        return this.currencies.stream().filter(currency -> currency.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    @Override
    public Currency getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Override
    public boolean currencyExist(String name) {
        return this.currencies.stream().anyMatch(currency -> currency.getSingular().equalsIgnoreCase(name) || currency.getPlural().equalsIgnoreCase(name));
    }

    @Override
    public void updateDefaultCurrency() {
        this.defaultCurrency = this.currencies.stream().filter(Currency::isDefaultCurrency).findFirst().orElse(this.defaultCurrency);
    }

    @Override
    public boolean existsDefaultCurrency() {
        return this.currencies.stream().anyMatch(Currency::isDefaultCurrency);
    }
}

