/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.services;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.aplication.events.EventRegistry;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.offers.Offer;
import BlockDynasty.Economy.domain.events.offersEvents.OfferEvent;
import BlockDynasty.Economy.domain.events.offersEvents.OfferExpired;
import BlockDynasty.Economy.domain.services.IOfferService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class OfferService
implements IOfferService {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final Map<Offer, ScheduledFuture<?>> ofertasPendientes = new ConcurrentHashMap();
    private final Courier courier;
    private final EventManager eventManager;
    private int delay = 60;

    public OfferService(Courier courier, EventManager eventManager, int delay) {
        this.courier = courier;
        this.eventManager = eventManager;
        if (delay > 0) {
            this.delay = delay;
        }
    }

    public OfferService(Courier courier, EventManager eventManager) {
        this.courier = courier;
        this.eventManager = eventManager;
    }

    @Override
    public Offer createOffer(Player playerSender, Player playerReceiver, BigDecimal amountCurrencyValue, BigDecimal amountCurrencyOffer, Currency currencyValue, Currency currencyOffer) {
        Offer offer = new Offer(playerSender, playerReceiver, amountCurrencyValue, amountCurrencyOffer, currencyValue, currencyOffer);
        this.addOffer(offer);
        return offer;
    }

    public void addOffer(Offer offer) {
        ScheduledFuture<?> oldTask = this.ofertasPendientes.get(offer);
        if (oldTask != null) {
            oldTask.cancel(false);
            this.ofertasPendientes.remove(offer);
        }
        ScheduledFuture<?> expirationTask = this.scheduler.schedule(() -> this.expireOfferLocally(offer, true), (long)this.delay, TimeUnit.SECONDS);
        this.ofertasPendientes.put(offer, expirationTask);
    }

    public void expireOfferLocally(Offer offer, boolean broadcastNetwork) {
        this.ofertasPendientes.remove(offer);
        if (broadcastNetwork) {
            this.eventManager.emit(new OfferExpired(offer));
            this.courier.sendUpdateMessage("event", new OfferExpired(offer).toJson(), offer.getComprador().getUuid().toString());
            this.courier.sendUpdateMessage("event", new OfferExpired(offer).toJson(), offer.getVendedor().getUuid().toString());
        }
    }

    @Override
    public void expireOffer(Offer offer) {
        this.expireOfferLocally(offer, true);
    }

    public void expireOfferFromEvent(Offer offer) {
        ScheduledFuture<?> oldTask = this.ofertasPendientes.get(offer);
        if (oldTask != null) {
            oldTask.cancel(false);
            this.expireOfferLocally(offer, false);
        }
    }

    @Override
    public boolean cancelOffer(UUID initiator) {
        Map.Entry entryToRemove = this.ofertasPendientes.entrySet().stream().filter(entry -> {
            Offer offer = (Offer)entry.getKey();
            return offer.getVendedor().getUuid().equals(initiator) || offer.getComprador().getUuid().equals(initiator);
        }).findFirst().orElse(null);
        if (entryToRemove != null) {
            Offer offer = (Offer)entryToRemove.getKey();
            ((ScheduledFuture)entryToRemove.getValue()).cancel(false);
            this.ofertasPendientes.remove(offer);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptOffer(UUID playerReceiver, UUID playerSender) {
        ScheduledFuture<?> task;
        Offer offerToAccept = this.getOffer(playerSender, playerReceiver);
        if (offerToAccept != null && (task = this.ofertasPendientes.get(offerToAccept)) != null) {
            task.cancel(false);
            this.ofertasPendientes.remove(offerToAccept);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOfferTo(UUID player) {
        for (Offer offer : this.ofertasPendientes.keySet()) {
            if (!offer.getComprador().getUuid().equals(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processNetworkEvent(String jsonEvent) {
        OfferEvent offerEvent = EventRegistry.deserializeOfferEvent(jsonEvent);
        if (offerEvent != null) {
            offerEvent.syncOffer(this);
        }
    }

    @Override
    public Offer getOfferSeller(UUID playerId) {
        return this.ofertasPendientes.keySet().stream().filter(offer -> offer.getVendedor().getUuid().equals(playerId)).findFirst().orElse(null);
    }

    @Override
    public Offer getOfferBuyer(UUID playerId) {
        return this.ofertasPendientes.keySet().stream().filter(offer -> offer.getComprador().getUuid().equals(playerId)).findFirst().orElse(null);
    }

    @Override
    public Offer getOffer(UUID player1Id, UUID player2Id) {
        return this.ofertasPendientes.keySet().stream().filter(offer -> offer.getVendedor().getUuid().equals(player1Id) && offer.getComprador().getUuid().equals(player2Id) || offer.getVendedor().getUuid().equals(player2Id) && offer.getComprador().getUuid().equals(player1Id)).findFirst().orElse(null);
    }

    @Override
    public List<Offer> getOffersSeller(UUID playerId) {
        return this.ofertasPendientes.keySet().stream().filter(offer -> offer.getVendedor().getUuid().equals(playerId)).collect(Collectors.toList());
    }

    @Override
    public List<Offer> getOffersBuyer(UUID playerId) {
        return this.ofertasPendientes.keySet().stream().filter(offer -> offer.getComprador().getUuid().equals(playerId)).collect(Collectors.toList());
    }
}

