/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.events.transactionsEvents;

import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.events.SerializableEvent;
import java.math.BigDecimal;

public class WithdrawEvent
extends SerializableEvent {
    private final Context context;
    private final Currency currency;
    private final Player player;
    private final BigDecimal amount;

    public WithdrawEvent(Player player, Currency currency, BigDecimal amount) {
        this.currency = new Currency(currency);
        this.player = new Player(player);
        this.amount = amount;
        this.context = Context.OTHER;
    }

    public WithdrawEvent(Player player, Currency currency, BigDecimal amount, Context context) {
        this.context = context;
        this.currency = new Currency(currency);
        this.player = new Player(player);
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Context getContext() {
        return this.context;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String toString() {
        return "WithdrawEvent{currency=" + this.currency.getSingular() + ", player=" + this.player.getNickname() + ", amount=" + this.amount.toString() + "}";
    }
}

