/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty;

import java.math.BigDecimal;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.plugin.PluginContainer;

public class TestEconomyCommand {
    public static void registerTestCommand(RegisterCommandEvent<Command.Parameterized> event, PluginContainer container) {
        Command.Parameterized ecoTestCommand = Command.builder().permission("blockdynasty.ecotester").executor(context -> {
            if (context.cause().root() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)context.cause().root();
                Sponge.server().serviceProvider().economyService().ifPresent(economyService -> {
                    Optional account = economyService.findOrCreateAccount(player.uniqueId());
                    if (account.isPresent()) {
                        player.sendMessage(Component.text((String)"---------------------------------").color((TextColor)NamedTextColor.GOLD));
                        player.sendMessage((Component)Component.text((String)("Account found: " + String.valueOf(((UniqueAccount)account.get()).balance(economyService.defaultCurrency())))));
                        TransactionResult result = ((UniqueAccount)account.get()).deposit(economyService.defaultCurrency(), BigDecimal.valueOf(100L), Cause.of((EventContext)EventContext.empty(), (Object)container));
                        player.sendMessage((Component)Component.text((String)("Deposit result: " + result.result().name())));
                        player.sendMessage((Component)Component.text((String)("New balance: " + String.valueOf(((UniqueAccount)account.get()).balance(economyService.defaultCurrency())))));
                        TransactionResult resultWithdraw = ((UniqueAccount)account.get()).withdraw(economyService.defaultCurrency(), BigDecimal.valueOf(50L), Cause.of((EventContext)EventContext.empty(), (Object)container));
                        player.sendMessage((Component)Component.text((String)("Withdraw result: " + resultWithdraw.result().name())));
                        player.sendMessage((Component)Component.text((String)("New balance: " + String.valueOf(((UniqueAccount)account.get()).balance(economyService.defaultCurrency())))));
                        Optional accountCris = economyService.findOrCreateAccount("Cris");
                        TransferResult resultTransfer = ((UniqueAccount)account.get()).transfer((Account)accountCris.get(), economyService.defaultCurrency(), BigDecimal.valueOf(1L), Cause.of((EventContext)EventContext.empty(), (Object)container));
                        player.sendMessage((Component)Component.text((String)("Transfer result: " + resultTransfer.result().name())));
                        player.sendMessage((Component)Component.text((String)("Your new balance: " + String.valueOf(((UniqueAccount)account.get()).balance(economyService.defaultCurrency())))));
                        player.sendMessage((Component)Component.text((String)("Cris's new balance: " + String.valueOf(((Account)accountCris.get()).balance(economyService.defaultCurrency())))));
                        player.sendMessage(Component.text((String)"---------------------------------").color((TextColor)NamedTextColor.GOLD));
                    } else {
                        player.sendMessage(Component.text((String)"Failed to find or create account!").color((TextColor)NamedTextColor.RED));
                    }
                });
                return CommandResult.success();
            }
            return CommandResult.error((Component)Component.text((String)"Only players can use this command"));
        }).build();
        event.register(container, (Object)ecoTestCommand, "ecotest", new String[0]);
    }
}

