/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis;

import com.BlockDynasty.redis.clients.jedis.Connection;
import com.BlockDynasty.redis.clients.jedis.ConnectionPool;
import com.BlockDynasty.redis.clients.jedis.HostAndPort;
import com.BlockDynasty.redis.clients.jedis.JedisClientConfig;
import com.BlockDynasty.redis.clients.jedis.Protocol;
import com.BlockDynasty.redis.clients.jedis.annots.Experimental;
import com.BlockDynasty.redis.clients.jedis.annots.Internal;
import com.BlockDynasty.redis.clients.jedis.commands.ProtocolCommand;
import com.BlockDynasty.redis.clients.jedis.csc.Cache;
import com.BlockDynasty.redis.clients.jedis.exceptions.JedisClusterOperationException;
import com.BlockDynasty.redis.clients.jedis.util.SafeEncoder;
import com.BlockDynasty.slf4j.Logger;
import com.BlockDynasty.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

@Internal
public class JedisClusterInfoCache {
    private static final Logger logger = LoggerFactory.getLogger(JedisClusterInfoCache.class);
    private final Map<String, ConnectionPool> nodes = new HashMap<String, ConnectionPool>();
    private final ConnectionPool[] slots = new ConnectionPool[16384];
    private final HostAndPort[] slotNodes = new HostAndPort[16384];
    private final List<ConnectionPool>[] replicaSlots;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock rediscoverLock = new ReentrantLock();
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final JedisClientConfig clientConfig;
    private final Cache clientSideCache;
    private final Set<HostAndPort> startNodes;
    private static final int MASTER_NODE_INDEX = 2;
    private ScheduledExecutorService topologyRefreshExecutor = null;

    public JedisClusterInfoCache(JedisClientConfig clientConfig, Set<HostAndPort> startNodes) {
        this(clientConfig, null, null, startNodes);
    }

    @Experimental
    public JedisClusterInfoCache(JedisClientConfig clientConfig, Cache clientSideCache, Set<HostAndPort> startNodes) {
        this(clientConfig, clientSideCache, null, startNodes);
    }

    public JedisClusterInfoCache(JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> startNodes) {
        this(clientConfig, null, poolConfig, startNodes);
    }

    @Experimental
    public JedisClusterInfoCache(JedisClientConfig clientConfig, Cache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> startNodes) {
        this(clientConfig, clientSideCache, poolConfig, startNodes, null);
    }

    public JedisClusterInfoCache(JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> startNodes, Duration topologyRefreshPeriod) {
        this(clientConfig, null, poolConfig, startNodes, topologyRefreshPeriod);
    }

    @Experimental
    public JedisClusterInfoCache(JedisClientConfig clientConfig, Cache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> startNodes, Duration topologyRefreshPeriod) {
        this.poolConfig = poolConfig;
        this.clientConfig = clientConfig;
        this.clientSideCache = clientSideCache;
        this.startNodes = startNodes;
        if (topologyRefreshPeriod != null) {
            logger.info("Cluster topology refresh start, period: {}, startNodes: {}", (Object)topologyRefreshPeriod, (Object)startNodes);
            this.topologyRefreshExecutor = Executors.newSingleThreadScheduledExecutor();
            this.topologyRefreshExecutor.scheduleWithFixedDelay(new TopologyRefreshTask(), topologyRefreshPeriod.toMillis(), topologyRefreshPeriod.toMillis(), TimeUnit.MILLISECONDS);
        }
        this.replicaSlots = clientConfig.isReadOnlyForRedisClusterReplicas() ? new ArrayList[16384] : null;
    }

    private boolean checkClusterSlotSequence(List<Object> slotsInfo) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (Object slotInfoObj : slotsInfo) {
            List slotInfo = (List)slotInfoObj;
            slots.addAll(this.getAssignedSlotArray(slotInfo));
        }
        Collections.sort(slots);
        if (slots.size() != 16384) {
            return false;
        }
        for (int i = 0; i < 16384; ++i) {
            if (i == (Integer)slots.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterNodesAndSlots(Connection jedis) {
        List<Object> slotsInfo = this.executeClusterSlots(jedis);
        if (System.getProperty("jedis.cluster.initNoError") == null) {
            if (slotsInfo.isEmpty()) {
                throw new JedisClusterOperationException("Cluster slots list is empty.");
            }
            if (!this.checkClusterSlotSequence(slotsInfo)) {
                throw new JedisClusterOperationException("Cluster slots have holes.");
            }
        }
        this.w.lock();
        try {
            this.reset();
            for (Object slotInfoObj : slotsInfo) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.isEmpty()) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    this.setupNodeIfNotExist(targetNode);
                    if (i == 2) {
                        this.assignSlotsToNode(slotNums, targetNode);
                        continue;
                    }
                    if (!this.clientConfig.isReadOnlyForRedisClusterReplicas()) continue;
                    this.assignSlotsToReplicaNode(slotNums, targetNode);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void renewClusterSlots(Connection jedis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 32[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverClusterSlots(Connection jedis) {
        List<Object> slotsInfo = this.executeClusterSlots(jedis);
        if (System.getProperty("jedis.cluster.initNoError") == null) {
            if (slotsInfo.isEmpty()) {
                throw new JedisClusterOperationException("Cluster slots list is empty.");
            }
            if (!this.checkClusterSlotSequence(slotsInfo)) {
                throw new JedisClusterOperationException("Cluster slots have holes.");
            }
        }
        this.w.lock();
        try {
            Arrays.fill(this.slots, null);
            Arrays.fill(this.slotNodes, null);
            if (this.clientSideCache != null) {
                this.clientSideCache.flush();
            }
            HashSet<String> hostAndPortKeys = new HashSet<String>();
            for (Object slotInfoObj : slotsInfo) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.isEmpty()) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    hostAndPortKeys.add(JedisClusterInfoCache.getNodeKey(targetNode));
                    this.setupNodeIfNotExist(targetNode);
                    if (i == 2) {
                        this.assignSlotsToNode(slotNums, targetNode);
                        continue;
                    }
                    if (!this.clientConfig.isReadOnlyForRedisClusterReplicas()) continue;
                    this.assignSlotsToReplicaNode(slotNums, targetNode);
                }
            }
            Iterator<Map.Entry<String, ConnectionPool>> entryIt = this.nodes.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry<String, ConnectionPool> entry = entryIt.next();
                if (hostAndPortKeys.contains(entry.getKey())) continue;
                ConnectionPool pool = entry.getValue();
                try {
                    if (pool != null) {
                        pool.destroy();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                entryIt.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private HostAndPort generateHostAndPort(List<Object> hostInfos) {
        String host = SafeEncoder.encode((byte[])hostInfos.get(0));
        int port = ((Long)hostInfos.get(1)).intValue();
        return new HostAndPort(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool setupNodeIfNotExist(HostAndPort node) {
        this.w.lock();
        try {
            String nodeKey = JedisClusterInfoCache.getNodeKey(node);
            ConnectionPool existingPool = this.nodes.get(nodeKey);
            if (existingPool != null) {
                ConnectionPool connectionPool = existingPool;
                return connectionPool;
            }
            ConnectionPool nodePool = this.createNodePool(node);
            this.nodes.put(nodeKey, nodePool);
            ConnectionPool connectionPool = nodePool;
            return connectionPool;
        }
        finally {
            this.w.unlock();
        }
    }

    private ConnectionPool createNodePool(HostAndPort node) {
        if (this.poolConfig == null) {
            if (this.clientSideCache == null) {
                return new ConnectionPool(node, this.clientConfig);
            }
            return new ConnectionPool(node, this.clientConfig, this.clientSideCache);
        }
        if (this.clientSideCache == null) {
            return new ConnectionPool(node, this.clientConfig, this.poolConfig);
        }
        return new ConnectionPool(node, this.clientConfig, this.clientSideCache, this.poolConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.w.lock();
        try {
            ConnectionPool targetPool;
            this.slots[slot] = targetPool = this.setupNodeIfNotExist(targetNode);
            this.slotNodes[slot] = targetNode;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToNode(List<Integer> targetSlots, HostAndPort targetNode) {
        this.w.lock();
        try {
            ConnectionPool targetPool = this.setupNodeIfNotExist(targetNode);
            for (Integer slot : targetSlots) {
                this.slots[slot.intValue()] = targetPool;
                this.slotNodes[slot.intValue()] = targetNode;
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToReplicaNode(List<Integer> targetSlots, HostAndPort targetNode) {
        this.w.lock();
        try {
            ConnectionPool targetPool = this.setupNodeIfNotExist(targetNode);
            for (Integer slot : targetSlots) {
                if (this.replicaSlots[slot] == null) {
                    this.replicaSlots[slot.intValue()] = new ArrayList<ConnectionPool>();
                }
                this.replicaSlots[slot].add(targetPool);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public ConnectionPool getNode(String nodeKey) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.nodes.get(nodeKey);
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public ConnectionPool getNode(HostAndPort node) {
        return this.getNode(JedisClusterInfoCache.getNodeKey(node));
    }

    public ConnectionPool getSlotPool(int slot) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.slots[slot];
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public HostAndPort getSlotNode(int slot) {
        this.r.lock();
        try {
            HostAndPort hostAndPort = this.slotNodes[slot];
            return hostAndPort;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<ConnectionPool> getSlotReplicaPools(int slot) {
        this.r.lock();
        try {
            List<ConnectionPool> list = this.replicaSlots[slot];
            return list;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<String, ConnectionPool> getNodes() {
        this.r.lock();
        try {
            HashMap<String, ConnectionPool> hashMap = new HashMap<String, ConnectionPool>(this.nodes);
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<ConnectionPool> getShuffledNodesPool() {
        this.r.lock();
        try {
            ArrayList<ConnectionPool> pools = new ArrayList<ConnectionPool>(this.nodes.values());
            Collections.shuffle(pools);
            ArrayList<ConnectionPool> arrayList = pools;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.w.lock();
        try {
            for (ConnectionPool pool : this.nodes.values()) {
                try {
                    if (pool == null) continue;
                    pool.destroy();
                }
                catch (RuntimeException runtimeException) {}
            }
            this.nodes.clear();
            Arrays.fill(this.slots, null);
            Arrays.fill(this.slotNodes, null);
        }
        finally {
            this.w.unlock();
        }
    }

    public void close() {
        this.reset();
        if (this.topologyRefreshExecutor != null) {
            logger.info("Cluster topology refresh shutdown, startNodes: {}", (Object)this.startNodes);
            this.topologyRefreshExecutor.shutdownNow();
        }
    }

    public static String getNodeKey(HostAndPort hnp) {
        return hnp.toString();
    }

    private List<Object> executeClusterSlots(Connection jedis) {
        jedis.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "SLOTS");
        return jedis.getObjectMultiBulkReply();
    }

    private List<Integer> getAssignedSlotArray(List<Object> slotInfo) {
        ArrayList<Integer> slotNums = new ArrayList<Integer>();
        for (int slot = ((Long)slotInfo.get(0)).intValue(); slot <= ((Long)slotInfo.get(1)).intValue(); ++slot) {
            slotNums.add(slot);
        }
        return slotNums;
    }

    class TopologyRefreshTask
    implements Runnable {
        TopologyRefreshTask() {
        }

        @Override
        public void run() {
            logger.debug("Cluster topology refresh run, old nodes: {}", (Object)JedisClusterInfoCache.this.nodes.keySet());
            JedisClusterInfoCache.this.renewClusterSlots(null);
            logger.debug("Cluster topology refresh run, new nodes: {}", (Object)JedisClusterInfoCache.this.nodes.keySet());
        }
    }
}

