/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis.params;

import com.BlockDynasty.redis.clients.jedis.CommandArguments;
import com.BlockDynasty.redis.clients.jedis.Protocol;
import com.BlockDynasty.redis.clients.jedis.params.IParams;
import com.BlockDynasty.redis.clients.jedis.util.SafeEncoder;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class ScanParams
implements IParams {
    private final Map<Protocol.Keyword, ByteBuffer> params = new EnumMap<Protocol.Keyword, ByteBuffer>(Protocol.Keyword.class);
    public static final String SCAN_POINTER_START = String.valueOf(0);
    public static final byte[] SCAN_POINTER_START_BINARY = SafeEncoder.encode(SCAN_POINTER_START);

    public ScanParams match(byte[] pattern) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(pattern));
        return this;
    }

    public ScanParams match(String pattern) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(SafeEncoder.encode(pattern)));
        return this;
    }

    public ScanParams count(Integer count) {
        this.params.put(Protocol.Keyword.COUNT, ByteBuffer.wrap(Protocol.toByteArray(count)));
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        for (Map.Entry<Protocol.Keyword, ByteBuffer> param : this.params.entrySet()) {
            args.add(param.getKey());
            args.add(param.getValue().array());
        }
    }

    public byte[] binaryMatch() {
        if (this.params.containsKey(Protocol.Keyword.MATCH)) {
            return this.params.get(Protocol.Keyword.MATCH).array();
        }
        return null;
    }

    public String match() {
        if (this.params.containsKey(Protocol.Keyword.MATCH)) {
            return new String(this.params.get(Protocol.Keyword.MATCH).array());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanParams that = (ScanParams)o;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }
}

