/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis.search.aggr;

import com.BlockDynasty.redis.clients.jedis.CommandArguments;
import com.BlockDynasty.redis.clients.jedis.providers.ConnectionProvider;
import com.BlockDynasty.redis.clients.jedis.search.SearchProtocol;
import com.BlockDynasty.redis.clients.jedis.search.aggr.AggregationBuilder;
import com.BlockDynasty.redis.clients.jedis.search.aggr.AggregationResult;
import com.BlockDynasty.redis.clients.jedis.search.aggr.Row;
import com.BlockDynasty.redis.clients.jedis.util.JedisCommandIterationBase;
import java.util.Collection;

public class FtAggregateIteration
extends JedisCommandIterationBase<AggregationResult, Row> {
    private final String indexName;
    private final CommandArguments args;

    public FtAggregateIteration(ConnectionProvider connectionProvider, String indexName, AggregationBuilder aggr) {
        super(connectionProvider, AggregationResult.SEARCH_AGGREGATION_RESULT_WITH_CURSOR);
        if (!aggr.isWithCursor()) {
            throw new IllegalArgumentException("cursor must be set");
        }
        this.indexName = indexName;
        this.args = new CommandArguments(SearchProtocol.SearchCommand.AGGREGATE).add(this.indexName).addParams(aggr);
    }

    @Override
    protected boolean isNodeCompleted(AggregationResult reply) {
        return reply.getCursorId() == 0L;
    }

    @Override
    protected CommandArguments initCommandArguments() {
        return this.args;
    }

    @Override
    protected CommandArguments nextCommandArguments(AggregationResult lastReply) {
        return new CommandArguments(SearchProtocol.SearchCommand.CURSOR).add(SearchProtocol.SearchKeyword.READ).add(this.indexName).add(lastReply.getCursorId());
    }

    @Override
    protected Collection<Row> convertBatchToData(AggregationResult batch) {
        return batch.getRows();
    }
}

