/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class EditPayableCommand
extends AbstractCommand {
    private final EditCurrencyUseCase toggleFeaturesUseCase;

    public EditPayableCommand(EditCurrencyUseCase toggleFeaturesUseCase) {
        super("payable", "", List.of("currency"));
        this.toggleFeaturesUseCase = toggleFeaturesUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        try {
            this.toggleFeaturesUseCase.togglePayable(currencyName);
            sender.sendMessage("Toggled payability for " + currencyName);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Unknown currency.");
        }
        catch (TransactionException e) {
            sender.sendMessage("An error occurred while toggling payability for " + currencyName);
        }
        return true;
    }
}

