/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class EditRateCommand
extends AbstractCommand {
    private final EditCurrencyUseCase editCurrencyUseCase;

    public EditRateCommand(EditCurrencyUseCase editCurrencyUseCase) {
        super("rate", "", List.of("currency", "rate"));
        this.editCurrencyUseCase = editCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        double amount;
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        String rate = args[1];
        try {
            amount = Double.parseDouble(rate);
            if (amount <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("Invalid amount");
            return false;
        }
        double finalAmount = amount;
        try {
            this.editCurrencyUseCase.setCurrencyRate(currencyName, finalAmount);
            sender.sendMessage("Rate currency updated for " + currencyName + " to " + rate);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Unknown currency");
        }
        catch (TransactionException e) {
            sender.sendMessage("error while updating the rate");
        }
        return true;
    }
}

