/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.users;

import BlockDynasty.Economy.aplication.useCase.transaction.ExchangeUseCase;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;

public class ExchangeCommand
extends AbstractCommand {
    private ExchangeUseCase exchange;

    public ExchangeCommand(ExchangeUseCase exchange) {
        super("exchange", "BlockDynastyEconomy.players.exchange", List.of("fromCurrency", "toCurrency", "toAmount"));
        this.exchange = exchange;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        double toReceiveAmount = 0.0;
        try {
            toReceiveAmount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(MessageService.getMessage("invalidamount"));
            return true;
        }
        String toExchange = args[0];
        String toReceive = args[1];
        double finalToReceiveAmount = toReceiveAmount;
        Result<BigDecimal> result = this.exchange.execute(sender.getName(), toExchange, toReceive, null, BigDecimal.valueOf(finalToReceiveAmount));
        if (!result.isSuccess()) {
            sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
        }
        return true;
    }
}

