/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.components.abstractions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lib.abstractions.PlatformAdapter;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IGUIService;
import lib.gui.components.IInventory;
import lib.gui.components.IItemStack;
import lib.gui.components.Materials;

public class AbstractPanel
implements IGUI {
    protected static PlatformAdapter platformAdapter;
    protected static IGUIService guiService;
    protected IInventory inventory;
    protected final IEntityGUI owner;
    protected IGUI parent;
    protected final Map<Integer, IItemStack> items = new HashMap<Integer, IItemStack>();
    protected final Map<Integer, Consumer<IEntityGUI>> leftClickActions = new HashMap<Integer, Consumer<IEntityGUI>>();
    protected final Map<Integer, Consumer<IEntityGUI>> rightClickActions = new HashMap<Integer, Consumer<IEntityGUI>>();

    public static void setPlatformAdapter(PlatformAdapter adapter, IGUIService guiServices) {
        platformAdapter = adapter;
        guiService = guiServices;
    }

    public AbstractPanel(String title, int rows, IEntityGUI owner) {
        this.createInventory(title, rows);
        this.fill();
        this.owner = owner;
        this.parent = null;
    }

    public AbstractPanel(String title, int rows, IEntityGUI owner, IGUI parent) {
        this(title, rows, owner);
        this.parent = parent;
    }

    private void createInventory(String title, int rows) {
        this.inventory = platformAdapter.createInventory(title, rows);
        this.inventory.setRows(rows);
        this.inventory.setTitle(title);
        this.items.forEach((key, value) -> this.inventory.set((int)key, (IItemStack)value));
    }

    protected IItemStack createItem(Materials material, String name, String ... lore) {
        IItemStack item = platformAdapter.createItemStack(material);
        item.setDisplayName(name);
        item.setLore(Arrays.asList(lore));
        return item;
    }

    protected void setItem(int slot, IItemStack item, Consumer<IEntityGUI> leftClickAction) {
        this.items.put(slot, item);
        this.inventory.set(slot, item);
        if (item == null || leftClickAction == null) {
            this.leftClickActions.remove(slot);
        } else {
            this.leftClickActions.put(slot, leftClickAction);
        }
    }

    protected void setItem(int slot, IItemStack item, Consumer<IEntityGUI> leftClickAction, Consumer<IEntityGUI> rightClickAction) {
        this.setItem(slot, item, leftClickAction);
        if (item == null || rightClickAction == null) {
            this.rightClickActions.remove(slot);
        } else {
            this.rightClickActions.put(slot, rightClickAction);
        }
    }

    @Override
    public void close() {
        this.owner.closeInventory();
        guiService.unregisterGUI(this.owner);
    }

    @Override
    public void open() {
        this.createInventory(this.inventory.getTitle(), this.inventory.getRows());
        this.owner.openInventory(this.inventory);
        guiService.registerGUI(this.owner, this);
    }

    @Override
    public void openParent() {
        if (this.hasParent()) {
            this.parent.open();
        } else {
            this.owner.closeInventory();
        }
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public IGUI getParent() {
        return this.parent;
    }

    @Override
    public void handleRightClick(int slot, IEntityGUI player) {
        Consumer<IEntityGUI> action = this.rightClickActions.get(slot);
        if (action != null) {
            action.accept(player);
            player.playSuccessSound();
        } else {
            player.playFailureSound();
        }
    }

    @Override
    public void handleLeftClick(int slot, IEntityGUI player) {
        Consumer<IEntityGUI> action = this.leftClickActions.get(slot);
        if (action != null) {
            action.accept(player);
            player.playSuccessSound();
        } else {
            player.playFailureSound();
        }
    }

    @Override
    public String getTitle() {
        return this.inventory.getTitle();
    }

    @Override
    public int getRows() {
        return this.inventory.getRows();
    }

    @Override
    public void fill() {
        IItemStack blueGlass = this.createItem(Materials.BLUE_STAINED_GLASS_PANE, " ", " ");
        IItemStack filler = this.createItem(Materials.GLASS_PANE, " ", " ");
        int rows = this.getRows() * 9 / 9;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = row * 9 + col;
                if (row == 0 || row == rows - 1 || col == 0 || col == 8) {
                    this.items.put(slot, blueGlass);
                    continue;
                }
                this.items.put(slot, filler);
            }
        }
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void refresh() {
    }
}

