/*
 * Decompiled with CFR 0.152.
 */
package lib.placeholder;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.util.List;
import java.util.Map;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;
import lib.util.colors.ChatColor;

public class PlaceHolder {
    private final SearchAccountUseCase searchAccountUseCase;
    private final SearchCurrencyUseCase searchCurrencyUseCase;

    public PlaceHolder(SearchAccountUseCase searchAccountUseCase, SearchCurrencyUseCase searchCurrencyUseCase) {
        this.searchAccountUseCase = searchAccountUseCase;
        this.searchCurrencyUseCase = searchCurrencyUseCase;
    }

    public String onRequest(IEntityCommands player, String s) {
        if (player == null || s == null) {
            return "";
        }
        if ((s = s.toLowerCase()).startsWith("top_")) {
            return this.handleTopPlaceholder(s);
        }
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(player.getUniqueId());
        if (!accountResult.isSuccess()) {
            return "Player data not found";
        }
        Result<Currency> defaultCurrencyResult = this.searchCurrencyUseCase.getDefaultCurrency();
        if (!defaultCurrencyResult.isSuccess()) {
            return "Default currency not found";
        }
        Account account = accountResult.getValue();
        Currency defaultCurrency = defaultCurrencyResult.getValue();
        if (s.startsWith("balance_")) {
            return this.handleBalancePlaceholder(s, account, defaultCurrency);
        }
        return null;
    }

    private String handleTopPlaceholder(String placeholder) {
        Result<List<Account>> result;
        int limit;
        String[] parts = placeholder.split("_");
        if (parts.length < 3) {
            return "Invalid placeholder format";
        }
        String currencyName = parts[1];
        try {
            limit = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            return "Invalid limit number";
        }
        int position = -1;
        if (parts.length >= 4) {
            try {
                position = Integer.parseInt(parts[3]) - 1;
            }
            catch (NumberFormatException e) {
                return "Invalid position number";
            }
        }
        if (!(result = this.searchAccountUseCase.getTopAccounts(currencyName, limit, 0)).isSuccess()) {
            return "No accounts found";
        }
        List<Account> accounts = result.getValue();
        if (position >= 0) {
            if (position >= accounts.size()) {
                return "Position out of range";
            }
            Account account = accounts.get(position);
            Money money = account.getMoney(currencyName);
            return MessageService.getMessage("balance_top.balance", Map.of("number", String.valueOf(position + 1), "currencycolor", ChatColor.formatColorToPlaceholder(money.getCurrency().getColor()), "player", account.getNickname(), "balance", money.format()));
        }
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < accounts.size(); ++i) {
            Account account = accounts.get(i);
            Money money = account.getMoney(currencyName);
            string.append(MessageService.getMessage("balance_top.balance", Map.of("number", String.valueOf(i + 1), "currencycolor", ChatColor.formatColorToPlaceholder(money.getCurrency().getColor()), "player", account.getNickname(), "balance", money.format())));
            if (i >= accounts.size() - 1) continue;
            string.append("\n");
        }
        return result.toString();
    }

    private String handleBalancePlaceholder(String placeholder, Account account, Currency defaultCurrency) {
        if (placeholder.equals("balance_default")) {
            return String.valueOf(Math.round(account.getMoney(defaultCurrency).getAmount().doubleValue()));
        }
        if (placeholder.equals("balance_default_formatted")) {
            return defaultCurrency.format(account.getMoney(defaultCurrency).getAmount());
        }
        String[] parts = placeholder.split("_");
        if (parts.length < 2) {
            return "Invalid placeholder format";
        }
        String currencyName = parts[1];
        Result<Currency> result = this.searchCurrencyUseCase.getCurrency(currencyName);
        if (!result.isSuccess()) {
            return "Currency not found";
        }
        Currency currency = result.getValue();
        if (placeholder.equals("balance_" + currencyName + "_formatted")) {
            return ChatColor.formatColorToPlaceholder(currency.getColor()) + currency.format(account.getMoney(currency).getAmount());
        }
        return String.valueOf(account.getMoney(currency).getAmount().doubleValue());
    }
}

