/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.dynamic.ClassFileLocator;

public final class OverridingClassFileLocator
implements ClassFileLocator {
    private final ConcurrentHashMap<String, ClassFileLocator.Resolution> registeredResolutions = new ConcurrentHashMap();
    private final ClassFileLocator parent;

    public OverridingClassFileLocator(ClassFileLocator parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    @Override
    public ClassFileLocator.Resolution locate(String name) throws IOException {
        ClassFileLocator.Resolution resolution = this.registeredResolutions.get(name);
        if (resolution != null) {
            return resolution;
        }
        return this.parent.locate(name);
    }

    @Override
    public void close() throws IOException {
    }

    void put(String className, ClassFileLocator.Resolution.Explicit explicit) {
        this.registeredResolutions.put(className, explicit);
    }

    void remove(String className) {
        this.registeredResolutions.remove(className);
    }
}

