/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.FirebirdSqlAstTranslator;
import org.hibernate.community.dialect.identity.FirebirdIdentityColumnSupport;
import org.hibernate.community.dialect.pagination.FirstSkipLimitHandler;
import org.hibernate.community.dialect.sequence.FirebirdSequenceSupport;
import org.hibernate.community.dialect.sequence.InterbaseSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorFirebirdDatabaseImpl;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.BinaryFloatDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class FirebirdDialect
extends Dialect {
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make(2, 5);
    private static final Pattern FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN = Pattern.compile("violation of .+? constraint \"([^\"]+)\"");
    private static final Pattern CHECK_CONSTRAINT_PATTERN = Pattern.compile("Operation violates CHECK constraint (.+?) on view or table");
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> {
        String message = sqle.getMessage();
        if (message != null) {
            Matcher foreignUniqueOrPrimaryKeyMatcher = FOREIGN_UNIQUE_OR_PRIMARY_KEY_PATTERN.matcher(message);
            if (foreignUniqueOrPrimaryKeyMatcher.find()) {
                return foreignUniqueOrPrimaryKeyMatcher.group(1);
            }
            Matcher checkConstraintMatcher = CHECK_CONSTRAINT_PATTERN.matcher(message);
            if (checkConstraintMatcher.find()) {
                return checkConstraintMatcher.group(1);
            }
        }
        return null;
    };
    private final FirebirdIndexExporter indexExporter = new FirebirdIndexExporter(this);

    public FirebirdDialect() {
        this(DEFAULT_VERSION);
    }

    public FirebirdDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public FirebirdDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getVersion().isBefore(3, 0) ? "smallint" : super.columnType(sqlTypeCode);
            }
            case -6: {
                return "smallint";
            }
            case 93: {
                return "timestamp";
            }
            case 2013: {
                return this.getVersion().isBefore(4, 0) ? "time" : "time with time zone";
            }
            case 2014: {
                return this.getVersion().isBefore(4, 0) ? "timestamp" : "timestamp with time zone";
            }
            case -2: {
                return this.getVersion().isBefore(4, 0) ? "char($l) character set octets" : super.columnType(sqlTypeCode);
            }
            case -3: {
                return this.getVersion().isBefore(4, 0) ? "varchar($l) character set octets" : super.columnType(sqlTypeCode);
            }
            case 2004: {
                return "blob sub_type binary";
            }
            case 2005: 
            case 2011: {
                return "blob sub_type text";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isBefore(4, 0)) {
            ddlTypeRegistry.addDescriptor(new BinaryFloatDdlType(this));
        }
    }

    @Override
    public int getMaxVarcharLength() {
        return 8191;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 32765;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 0;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isSameOrAfter(4, 0) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isBefore(3, 0) ? -7 : super.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public int getFloatPrecision() {
        return this.getVersion().isBefore(4, 0) ? 21 : 24;
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 3;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<byte[]> byteArrayType = basicTypeRegistry.resolve(StandardBasicTypes.BINARY);
        BasicType<Integer> integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
        BasicType<Short> shortType = basicTypeRegistry.resolve(StandardBasicTypes.SHORT);
        BasicType<Double> doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
        BasicType<Character> characterType = basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.concat_pipeOperator();
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        if (this.getVersion().isSameOrAfter(3, 0)) {
            functionFactory.moreHyperbolic();
            functionFactory.stddevPopSamp();
            functionFactory.varPopSamp();
            functionFactory.covarPopSamp();
            functionFactory.corr();
            functionFactory.regrLinearRegressionAggregates();
        }
        functionFactory.log();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cosh();
        functionFactory.trunc();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.substringFromFor();
        functionFactory.overlay();
        functionFactory.position();
        functionFactory.reverse();
        functionFactory.bitandorxornot_binAndOrXorNot();
        functionFactory.leastGreatest_minMaxValue();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.registerBinaryTernaryPattern("locate", integerType, "position(?1 in ?2)", "position(?1,?2,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, functionContributions.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
        functionRegistry.namedDescriptorBuilder("ascii_val").setExactArgumentCount(1).setInvariantType(shortType).register();
        functionRegistry.registerAlternateKey("ascii", "ascii_val");
        functionRegistry.namedDescriptorBuilder("ascii_char").setExactArgumentCount(1).setInvariantType(characterType).register();
        functionRegistry.registerAlternateKey("chr", "ascii_char");
        functionRegistry.registerAlternateKey("char", "ascii_char");
        functionRegistry.registerPattern("radians", "((?1)*pi()/180e0)", doubleType);
        functionRegistry.registerPattern("degrees", "((?1)*180e0/pi())", doubleType);
        if (this.getVersion().isSameOrAfter(3)) {
            functionFactory.windowFunctions();
            if (this.getVersion().isSameOrAfter(4, 0)) {
                Arrays.asList("md5", "sha1", "sha256", "sha512").forEach(hash -> functionRegistry.registerPattern((String)hash, "crypt_hash(?1 using " + hash + ")", byteArrayType));
                functionRegistry.registerAlternateKey("sha", "sha1");
                functionRegistry.registerPattern("crc32", "hash(?1 using crc32)", integerType);
            }
        }
        functionFactory.listagg_list("varchar");
    }

    @Override
    public String currentLocalTime() {
        if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
            return "localtime";
        }
        return super.currentLocalTime();
    }

    @Override
    public String currentLocalTimestamp() {
        if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
            return "localtimestamp";
        }
        return super.currentLocalTimestamp();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new FirebirdSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsTruncateWithCast() {
        return false;
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger(from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("true", "false") : BooleanDecoder.toBoolean(from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean(from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean(from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean(from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                String result = BooleanDecoder.toString(from);
                if (result == null) break;
                return "trim(" + result + ")";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: 
            case DAY_OF_YEAR: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
            case QUARTER: {
                return "((extract(month from ?2)+2)/3)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NATIVE: {
                return "dateadd((?2) millisecond to ?3)";
            }
            case NANOSECOND: {
                return "dateadd((?2)/1e6 millisecond to ?3)";
            }
            case WEEK: {
                return "dateadd((?2)*7 day to ?3)";
            }
            case QUARTER: {
                return "dateadd((?2)*3 month to ?3)";
            }
        }
        return "dateadd(?2 ?1 to ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NATIVE: {
                return "datediff(millisecond from ?2 to ?3)";
            }
            case NANOSECOND: {
                return "datediff(millisecond from ?2 to ?3)*1e6";
            }
            case WEEK: {
                return "datediff(day from ?2 to ?3)/7";
            }
            case QUARTER: {
                return "datediff(month from ?2 to ?3)/3";
            }
        }
        return "datediff(?1 from ?2 to ?3)";
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return this.getVersion().isSameOrAfter(4, 0);
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return this.getVersion().isBefore(4, 0) ? 18 : 38;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public int getMaxAliasLength() {
        return this.getVersion().isBefore(4, 0) ? 20 : 52;
    }

    @Override
    public int getMaxIdentifierLength() {
        return this.getVersion().isBefore(4) ? 31 : 63;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteKeywords(true);
        builder.setAutoQuoteInitialUnderscore(true);
        if (this.getVersion().isSameOrAfter(3, 0)) {
            builder.applyReservedWords("AVG", "BOOLEAN", "CHARACTER_LENGTH", "CHAR_LENGTH", "CORR", "COUNT", "COVAR_POP", "COVAR_SAMP", "EXTRACT", "LOWER", "MAX", "MIN", "OCTET_LENGTH", "POSITION", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "STDDEV_POP", "STDDEV_SAMP", "SUM", "TRIM", "UPPER", "VAR_POP", "VAR_SAMP");
        } else {
            builder.applyReservedWords("AVG", "CHARACTER_LENGTH", "CHAR_LENGTH", "COUNT", "EXTRACT", "LOWER", "MAX", "MIN", "OCTET_LENGTH", "POSITION", "SUM", "TRIM", "UPPER");
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return this.getVersion().isSameOrAfter(2, 0);
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1500;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    @Override
    public boolean supportsPartitionBy() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isBefore(3)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isBefore(3, 0) ? super.getIdentityColumnSupport() : FirebirdIdentityColumnSupport.INSTANCE;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        DatabaseVersion version = this.getVersion();
        if (version.isSameOrAfter(4)) {
            return FirebirdSequenceSupport.INSTANCE;
        }
        if (version.isSame(3)) {
            return FirebirdSequenceSupport.FB3_INSTANCE;
        }
        if (version.isSame(2)) {
            return FirebirdSequenceSupport.LEGACY_INSTANCE;
        }
        return InterbaseSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion().isBefore(3, 0) ? "select rdb$generator_name from rdb$generators" : "select rdb$generator_name,rdb$initial_value,rdb$generator_increment from rdb$generators where coalesce(rdb$system_flag,0)=0";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getVersion().isBefore(3, 0) ? SequenceNameExtractorImpl.INSTANCE : SequenceInformationExtractorFirebirdDatabaseImpl.INSTANCE;
    }

    @Override
    public String getForUpdateString() {
        return " with lock";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(3, 0) ? FirstSkipLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return this.getVersion().isBefore(2, 1) ? super.getSelectGUIDString() : "select uuid_to_char(gen_uuid()) from rdb$database";
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from rdb$database";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return this.getVersion().isSameOrAfter(2, 0) ? NullOrdering.SMALLEST : NullOrdering.LAST;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(1, 5);
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return type == FetchClauseType.ROWS_ONLY && this.getVersion().isSameOrAfter(3);
    }

    @Override
    public boolean supportsValuesListForInsert() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(3, 0);
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(4, 0);
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    protected boolean supportsPredicateAsExpression() {
        return this.getVersion().isSameOrAfter(3);
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public boolean hasDataTypeBeforeGeneratedAs() {
        return false;
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "yearday";
            }
            case DAY_OF_WEEK: {
                return "weekday";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                FirebirdDateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                FirebirdDateTimeUtils.appendAsTimestampWithMillis(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Firebird");
    }

    @Override
    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("char_to_uuid('");
        appender.appendSql(literal.toString());
        appender.appendSql("')");
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            String sqlExceptionMessage = sqlException.getMessage();
            switch (errorCode) {
                case 0x14000010: {
                    if (sqlExceptionMessage != null && sqlExceptionMessage.contains("update conflicts with concurrent update")) {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544345: 
                case 335544510: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 335544474: 
                case 335544475: 
                case 335544476: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 335544466: 
                case 335544558: 
                case 335544665: 
                case 336396758: 
                case 336396991: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            String exceptionMessage = sqlException.getMessage();
            if (exceptionMessage != null && (exceptionMessage.contains("violation of ") || exceptionMessage.contains("violates CHECK constraint"))) {
                String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, constraintName);
            }
            return null;
        };
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return this.getVersion().isBefore(2, 1) ? super.getFallbackSqmMutationStrategy(entityDescriptor, runtimeModelCreationContext) : new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, name -> "HT_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return this.getVersion().isBefore(2, 1) ? super.getFallbackSqmInsertStrategy(entityDescriptor, runtimeModelCreationContext) : new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    @Override
    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    @Override
    public String getDual() {
        return "rdb$database";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    private static final class FirebirdDateTimeUtils {
        private static final DateTimeFormatter OFFSET_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeUtils.DATE_TIME_FORMATTER_TIME).parseLenient().appendOffset("+HH:MM", "+00:00").parseStrict().toFormatter(Locale.ENGLISH);
        private static final DateTimeFormatter OFFSET_DATE_TIME_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeUtils.DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS).parseLenient().appendOffset("+HH:MM", "+00:00").parseStrict().toFormatter(Locale.ENGLISH);

        private FirebirdDateTimeUtils() {
        }

        private static void appendAsTime(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
            if (supportsOffset && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                OFFSET_TIME.formatTo(temporalAccessor, appender);
            } else {
                DateTimeUtils.appendAsTime(appender, temporalAccessor, supportsOffset, jdbcTimeZone);
            }
        }

        public static void appendAsTimestampWithMillis(SqlAppender appender, TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
            if (supportsOffset && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                OFFSET_DATE_TIME_MILLIS.formatTo(temporalAccessor, appender);
            } else if (supportsOffset && temporalAccessor instanceof Instant) {
                OFFSET_DATE_TIME_MILLIS.formatTo(((Instant)temporalAccessor).atZone(jdbcTimeZone.toZoneId()), appender);
            } else {
                DateTimeUtils.appendAsTimestampWithMillis(appender, temporalAccessor, supportsOffset, jdbcTimeZone);
            }
        }
    }

    private static class FirebirdIndexExporter
    extends StandardIndexExporter {
        public FirebirdIndexExporter(Dialect dialect) {
            super(dialect);
        }

        @Override
        public String[] getSqlCreateStrings(Index index, Metadata metadata, SqlStringGenerationContext context) {
            String tableName = context.format(index.getTable().getQualifiedTableName());
            Dialect dialect = this.getDialect();
            String indexNameForCreation = index.getQuotedName(dialect);
            String sortOrder = index.getColumnOrderMap().getOrDefault(index.getColumns().get(0), "asc");
            StringBuilder buf = new StringBuilder().append("desc".equalsIgnoreCase(sortOrder) || "descending".equalsIgnoreCase(sortOrder) ? "create desc index " : "create index ").append(indexNameForCreation).append(" on ").append(tableName).append(" (");
            boolean first = true;
            for (Column column : index.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(column.getQuotedName(dialect));
            }
            buf.append(')');
            return new String[]{buf.toString()};
        }
    }
}

