/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionEntry
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(CollectionEntry.class);
    private @Nullable @UnknownKeyFor @Initialized Serializable snapshot;
    private @Nullable @UnknownKeyFor @Initialized String role;
    private transient @Nullable @UnknownKeyFor @Initialized CollectionPersister loadedPersister;
    private @Nullable @UnknownKeyFor @Initialized Object loadedKey;
    private transient @UnknownKeyFor @NonNull @Initialized boolean reached;
    private transient @UnknownKeyFor @NonNull @Initialized boolean processed;
    private transient @UnknownKeyFor @NonNull @Initialized boolean doupdate;
    private transient @UnknownKeyFor @NonNull @Initialized boolean doremove;
    private transient @UnknownKeyFor @NonNull @Initialized boolean dorecreate;
    private transient @UnknownKeyFor @NonNull @Initialized boolean ignore;
    private transient @Nullable @UnknownKeyFor @Initialized CollectionPersister currentPersister;
    private transient @Nullable @UnknownKeyFor @Initialized Object currentKey;
    private @UnknownKeyFor @NonNull @Initialized boolean fromMerge;

    public CollectionEntry(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) {
        this.ignore = false;
        collection.clearDirty();
        this.snapshot = persister.isMutable() ? collection.getSnapshot(persister) : null;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public CollectionEntry(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized CollectionPersister loadedPersister, @UnknownKeyFor @NonNull @Initialized Object loadedKey, @UnknownKeyFor @NonNull @Initialized boolean ignore) {
        this.ignore = ignore;
        this.loadedKey = loadedKey;
        this.loadedPersister = loadedPersister;
        this.role = loadedPersister == null ? null : loadedPersister.getRole();
        collection.setSnapshot(loadedKey, this.role, null);
    }

    public CollectionEntry(@UnknownKeyFor @NonNull @Initialized CollectionPersister loadedPersister, @UnknownKeyFor @NonNull @Initialized Object loadedKey) {
        this.ignore = false;
        this.loadedKey = loadedKey;
        this.loadedPersister = loadedPersister;
        this.role = loadedPersister == null ? null : loadedPersister.getRole();
    }

    public CollectionEntry(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        this.ignore = false;
        this.loadedKey = collection.getKey();
        this.role = collection.getRole();
        this.loadedPersister = factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(NullnessUtil.castNonNull(this.role));
        this.snapshot = collection.getStoredSnapshot();
    }

    private CollectionEntry(@Nullable @UnknownKeyFor @Initialized String role, @UnknownKeyFor @NonNull @Initialized Serializable snapshot, @UnknownKeyFor @NonNull @Initialized Object loadedKey, @Nullable @UnknownKeyFor @Initialized SessionFactoryImplementor factory) {
        this.role = role;
        this.snapshot = snapshot;
        this.loadedKey = loadedKey;
        if (role != null) {
            this.afterDeserialize(factory);
        }
    }

    private void dirty(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        boolean forceDirty;
        CollectionPersister loadedPersister = this.getLoadedPersister();
        boolean bl = forceDirty = collection.wasInitialized() && !collection.isDirty() && loadedPersister != null && loadedPersister.isMutable() && (collection.isDirectlyAccessible() || loadedPersister.getElementType().isMutable()) && !collection.equalsSnapshot(loadedPersister);
        if (forceDirty) {
            collection.dirty();
        }
    }

    public void preFlush(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        boolean nonMutableChange;
        if (this.loadedKey == null && collection.getKey() != null) {
            this.loadedKey = collection.getKey();
        }
        CollectionPersister loadedPersister = this.getLoadedPersister();
        boolean bl = nonMutableChange = collection.isDirty() && loadedPersister != null && !loadedPersister.isMutable();
        if (nonMutableChange) {
            throw new HibernateException("changed an immutable collection instance: " + MessageHelper.collectionInfoString(NullnessUtil.castNonNull(loadedPersister).getRole(), this.getLoadedKey()));
        }
        this.dirty(collection);
        if (LOG.isDebugEnabled() && collection.isDirty() && loadedPersister != null) {
            LOG.debugf("Collection dirty: %s", (Object)MessageHelper.collectionInfoString(loadedPersister.getRole(), this.getLoadedKey()));
        }
        this.setReached(false);
        this.setProcessed(false);
        this.setDoupdate(false);
        this.setDoremove(false);
        this.setDorecreate(false);
    }

    public void postInitialize(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        CollectionPersister loadedPersister = this.getLoadedPersister();
        this.snapshot = loadedPersister != null && loadedPersister.isMutable() ? collection.getSnapshot(loadedPersister) : null;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
        if (loadedPersister != null && session.getLoadQueryInfluencers().effectivelyBatchLoadable(loadedPersister)) {
            session.getPersistenceContextInternal().getBatchFetchQueue().removeBatchLoadableCollection(this);
        }
    }

    public void postFlush(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (this.isIgnore()) {
            this.ignore = false;
        } else if (!this.isProcessed()) {
            throw new HibernateException(LOG.collectionNotProcessedByFlush(collection.getRole()));
        }
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public void afterAction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) {
        boolean resnapshot;
        this.loadedKey = this.getCurrentKey();
        this.setLoadedPersister(this.getCurrentPersister());
        boolean bl = resnapshot = collection.wasInitialized() && (this.isDoremove() || this.isDorecreate() || this.isDoupdate());
        if (resnapshot) {
            this.snapshot = this.loadedPersister == null || !this.loadedPersister.isMutable() ? null : collection.getSnapshot(NullnessUtil.castNonNull(this.loadedPersister));
        }
        collection.postAction();
    }

    public @Nullable @UnknownKeyFor @Initialized Object getKey() {
        return this.getLoadedKey();
    }

    public @Nullable @UnknownKeyFor @Initialized String getRole() {
        return this.role;
    }

    public @Nullable @UnknownKeyFor @Initialized Serializable getSnapshot() {
        return this.snapshot;
    }

    public void resetStoredSnapshot(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized Serializable storedSnapshot) {
        LOG.debugf("Reset storedSnapshot to %s for %s", (Object)storedSnapshot, (Object)this);
        if (this.fromMerge) {
            return;
        }
        this.snapshot = storedSnapshot;
        collection.setSnapshot(this.loadedKey, this.role, this.snapshot);
        this.fromMerge = true;
    }

    private void setLoadedPersister(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister) {
        this.loadedPersister = persister;
        this.setRole(persister == null ? null : persister.getRole());
    }

    void afterDeserialize(@Nullable @UnknownKeyFor @Initialized SessionFactoryImplementor factory) {
        this.loadedPersister = factory == null ? null : factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(NullnessUtil.castNonNull(this.role));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean wasDereferenced() {
        return this.getLoadedKey() == null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isReached() {
        return this.reached;
    }

    public void setReached(@UnknownKeyFor @NonNull @Initialized boolean reached) {
        this.reached = reached;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(@UnknownKeyFor @NonNull @Initialized boolean processed) {
        this.processed = processed;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDoupdate() {
        return this.doupdate;
    }

    public void setDoupdate(@UnknownKeyFor @NonNull @Initialized boolean doupdate) {
        this.doupdate = doupdate;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDoremove() {
        return this.doremove;
    }

    public void setDoremove(@UnknownKeyFor @NonNull @Initialized boolean doremove) {
        this.doremove = doremove;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDorecreate() {
        return this.dorecreate;
    }

    public void setDorecreate(@UnknownKeyFor @NonNull @Initialized boolean dorecreate) {
        this.dorecreate = dorecreate;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isIgnore() {
        return this.ignore;
    }

    public @Nullable @UnknownKeyFor @Initialized CollectionPersister getCurrentPersister() {
        return this.currentPersister;
    }

    public void setCurrentPersister(@Nullable @UnknownKeyFor @Initialized CollectionPersister currentPersister) {
        this.currentPersister = currentPersister;
    }

    public @Nullable @UnknownKeyFor @Initialized Object getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(@Nullable @UnknownKeyFor @Initialized Object currentKey) {
        this.currentKey = currentKey;
    }

    public @Nullable @UnknownKeyFor @Initialized CollectionPersister getLoadedPersister() {
        return this.loadedPersister;
    }

    public @Nullable @UnknownKeyFor @Initialized Object getLoadedKey() {
        return this.loadedKey;
    }

    public void setRole(@Nullable @UnknownKeyFor @Initialized String role) {
        this.role = role;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String result = "CollectionEntry" + MessageHelper.collectionInfoString(this.role, this.loadedKey);
        if (this.currentPersister != null) {
            result = result + "->" + MessageHelper.collectionInfoString(this.currentPersister.getRole(), this.currentKey);
        }
        return result;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getOrphans(@UnknownKeyFor @NonNull @Initialized String entityName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (this.snapshot == null) {
            throw new AssertionFailure("no collection snapshot for orphan delete");
        }
        return collection.getOrphans(this.snapshot, entityName);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSnapshotEmpty(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection) {
        CollectionPersister loadedPersister = this.getLoadedPersister();
        Serializable snapshot = this.getSnapshot();
        return !(!collection.wasInitialized() || loadedPersister != null && !loadedPersister.isMutable() || snapshot != null && !collection.isSnapshotEmpty(snapshot));
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.snapshot);
        oos.writeObject(this.loadedKey);
    }

    public static @UnknownKeyFor @NonNull @Initialized CollectionEntry deserialize(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois, @UnknownKeyFor @NonNull @Initialized SessionImplementor session) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        return new CollectionEntry((String)ois.readObject(), (Serializable)ois.readObject(), ois.readObject(), (SessionFactoryImplementor)(session == null ? null : session.getFactory()));
    }
}

