/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;

public enum EntityState {
    PERSISTENT,
    TRANSIENT,
    DETACHED,
    DELETED;

    static final CoreMessageLogger LOG;

    public static EntityState getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source, Boolean assumedUnsaved) {
        EntityPersister entityPersister;
        Object identifier;
        EntityKey entityKey;
        PersistenceContext persistenceContext;
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Persistent instance of: {0}", (Object)EventUtil.getLoggableName(entityName, entity));
                }
                return PERSISTENT;
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Deleted instance of: {0}", (Object)EventUtil.getLoggableName(entityName, entity));
            }
            return DELETED;
        }
        if (ForeignKeys.isTransient(entityName, entity, assumedUnsaved, source)) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Transient instance of: {0}", (Object)EventUtil.getLoggableName(entityName, entity));
            }
            return TRANSIENT;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Detached instance of: {0}", (Object)EventUtil.getLoggableName(entityName, entity));
        }
        if ((persistenceContext = source.getPersistenceContextInternal()).containsDeletedUnloadedEntityKeys() && persistenceContext.containsDeletedUnloadedEntityKey(entityKey = source.generateEntityKey(identifier = (entityPersister = source.getEntityPersister(entityName, entity)).getIdentifier(entity, source), entityPersister))) {
            return DELETED;
        }
        return DETACHED;
    }

    static {
        LOG = CoreLogging.messageLogger(EntityState.class);
    }
}

