/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.hibernate.Incubating;
import org.hibernate.boot.BootLogging;

@Incubating
public enum CollectionClassification {
    ARRAY(PluralAttribute.CollectionType.COLLECTION, true),
    BAG(PluralAttribute.CollectionType.COLLECTION, false),
    ID_BAG(PluralAttribute.CollectionType.COLLECTION, false),
    LIST(PluralAttribute.CollectionType.LIST, true),
    SET(PluralAttribute.CollectionType.SET, false),
    SORTED_SET(PluralAttribute.CollectionType.SET, false),
    ORDERED_SET(PluralAttribute.CollectionType.SET, false),
    MAP(PluralAttribute.CollectionType.MAP, true),
    SORTED_MAP(PluralAttribute.CollectionType.MAP, true),
    ORDERED_MAP(PluralAttribute.CollectionType.MAP, true);

    private final PluralAttribute.CollectionType jpaClassification;
    private final boolean isIndexed;

    private CollectionClassification(PluralAttribute.CollectionType jpaClassification, boolean isIndexed) {
        this.jpaClassification = jpaClassification;
        this.isIndexed = isIndexed;
    }

    public PluralAttribute.CollectionType toJpaClassification() {
        return this.jpaClassification;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean isRowUpdatePossible() {
        return this != BAG && this != SET;
    }

    public static CollectionClassification interpretSetting(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CollectionClassification) {
            return (CollectionClassification)((Object)value);
        }
        if (value instanceof String) {
            String string = (String)value;
            for (CollectionClassification collectionClassification : CollectionClassification.values()) {
                if (!collectionClassification.name().equalsIgnoreCase(string)) continue;
                return collectionClassification;
            }
            return null;
        }
        if (value instanceof Class) {
            return CollectionClassification.interpretClass((Class)value);
        }
        return null;
    }

    private static CollectionClassification interpretClass(Class<?> configuredClass) {
        if (List.class.isAssignableFrom(configuredClass)) {
            return LIST;
        }
        if (SortedSet.class.isAssignableFrom(configuredClass)) {
            return SORTED_SET;
        }
        if (Set.class.isAssignableFrom(configuredClass)) {
            return SET;
        }
        if (SortedMap.class.isAssignableFrom(configuredClass)) {
            return SORTED_MAP;
        }
        if (Map.class.isAssignableFrom(configuredClass)) {
            return MAP;
        }
        if (Collection.class.isAssignableFrom(configuredClass)) {
            return BAG;
        }
        BootLogging.BOOT_LOGGER.debugf("Unexpected Class specified for CollectionClassification resolution (`%s`) - should be one of `%s`, `%s`, `%s`, `%s`, `%s` or `%s`  (or subclass of)", configuredClass.getName(), List.class.getName(), SortedSet.class.getName(), Set.class.getName(), SortedMap.class.isAssignableFrom(configuredClass), Map.class.isAssignableFrom(configuredClass), Collection.class.getName());
        return null;
    }
}

