/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.BitSet;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.hibernate.QueryException;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.SyntaxException;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.PathElementException;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.internal.SqmTreePrinter;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmStatement;

public class StandardHqlTranslator
implements HqlTranslator {
    private final SqmCreationContext sqmCreationContext;
    private final SqmCreationOptions sqmCreationOptions;

    public StandardHqlTranslator(SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        this.sqmCreationContext = sqmCreationContext;
        this.sqmCreationOptions = sqmCreationOptions;
    }

    @Override
    public <R> SqmStatement<R> translate(String query, Class<R> expectedResultType) {
        HqlLogging.QUERY_LOGGER.debugf("HQL : %s", (Object)query);
        HqlParser.StatementContext hqlParseTree = this.parseHql(query);
        try {
            SqmStatement<R> sqmStatement = SemanticQueryBuilder.buildSemanticModel(hqlParseTree, expectedResultType, this.sqmCreationOptions, this.sqmCreationContext, query);
            SqmTreePrinter.logTree(sqmStatement);
            return sqmStatement;
        }
        catch (QueryException e) {
            throw e;
        }
        catch (PathElementException | TerminalPathException e) {
            throw new UnknownPathException(e.getMessage(), query, e);
        }
        catch (EntityTypeException e) {
            throw new UnknownEntityException(e.getMessage(), e.getReference(), e);
        }
        catch (Exception e) {
            throw new InterpretationException(query, e);
        }
    }

    private HqlParser.StatementContext parseHql(final String hql) {
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        HqlParser hqlParser = HqlParseTreeBuilder.INSTANCE.buildHqlParser(hql, hqlLexer);
        ANTLRErrorListener errorListener = new ANTLRErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new SyntaxException(StandardHqlTranslator.prettifyAntlrError(offendingSymbol, line, charPositionInLine, msg, e, hql, true), hql);
            }

            @Override
            public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            }

            @Override
            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            @Override
            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        };
        hqlLexer.addErrorListener(errorListener);
        ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        hqlParser.removeErrorListeners();
        hqlParser.addErrorListener(errorListener);
        hqlParser.setErrorHandler(new BailErrorStrategy());
        try {
            return hqlParser.statement();
        }
        catch (ParseCancellationException e) {
            hqlLexer.reset();
            hqlParser.reset();
            ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            hqlParser.setErrorHandler(new DefaultErrorStrategy());
            return hqlParser.statement();
        }
        catch (ParsingException ex) {
            throw new QueryException("Failed to interpret HQL syntax [" + ex.getMessage() + "]", hql, ex);
        }
    }

    public static String prettifyAntlrError(Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e, String hql, boolean includeLocation) {
        Object errorText = "";
        if (includeLocation) {
            String token;
            errorText = (String)errorText + "At " + line + ":" + charPositionInLine;
            if (offendingSymbol instanceof CommonToken && (token = ((CommonToken)offendingSymbol).getText()) != null && !token.isEmpty()) {
                errorText = (String)errorText + " and token '" + token + "'";
            }
            errorText = (String)errorText + ", ";
        }
        if (e instanceof NoViableAltException) {
            errorText = (String)errorText + message.substring(0, message.indexOf(39));
            if (hql.isEmpty()) {
                errorText = (String)errorText + "'*' (empty query string)";
            } else {
                String lineText = (String)hql.lines().collect(Collectors.toList()).get(line - 1);
                String text = lineText.substring(0, charPositionInLine) + "*" + lineText.substring(charPositionInLine);
                errorText = (String)errorText + "'" + text + "'";
            }
        } else {
            errorText = e instanceof InputMismatchException ? (String)errorText + message.substring(0, message.length() - 1).replace(" expecting {", ", expecting one of the following tokens: ") : (String)errorText + message;
        }
        return errorText;
    }
}

