/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.ManagedType;
import java.util.Map;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaMapJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedMapJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;

public class SqmMapJoin<O, K, V>
extends AbstractSqmPluralJoin<O, Map<K, V>, V>
implements JpaMapJoin<O, K, V> {
    public SqmMapJoin(SqmFrom<?, O> lhs, MapPersistentAttribute<O, K, V> pluralValuedNavigable, String alias, SqmJoinType sqmJoinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, pluralValuedNavigable, alias, sqmJoinType, fetched, nodeBuilder);
    }

    protected SqmMapJoin(SqmFrom<?, O> lhs, NavigablePath navigablePath, MapPersistentAttribute<O, K, V> pluralValuedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, navigablePath, pluralValuedNavigable, alias, joinType, fetched, nodeBuilder);
    }

    @Override
    public SqmMapJoin<O, K, V> copy(SqmCopyContext context) {
        SqmMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNode lhsCopy = this.getLhs().copy(context);
        SqmMapJoin<O, K, V> path = context.registerCopy(this, new SqmMapJoin<O, K, V>(lhsCopy, this.getNavigablePathCopy((SqmPath<?>)lhsCopy), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), context.copyFetchedFlag() && this.isFetched(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public MapPersistentAttribute<O, K, V> getModel() {
        return (MapPersistentAttribute)super.getModel();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitMapJoin(this);
    }

    @Override
    public MapPersistentAttribute<O, K, V> getAttribute() {
        return this.getModel();
    }

    @Override
    public SqmPath<K> key() {
        SqmPathSource keyPathSource = this.getAttribute().getKeyPathSource();
        return this.resolvePath(keyPathSource.getPathName(), keyPathSource);
    }

    @Override
    public SqmPath<V> value() {
        SqmPathSource elementPathSource = this.getAttribute().getElementPathSource();
        return this.resolvePath(elementPathSource.getPathName(), elementPathSource);
    }

    @Override
    public Expression<Map.Entry<K, V>> entry() {
        return new SqmMapEntryReference(this, this.nodeBuilder());
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaExpression<Boolean> restriction) {
        return (SqmMapJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Expression<Boolean> restriction) {
        return (SqmMapJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaPredicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Predicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    public SqmCorrelatedMapJoin<O, K, V> createCorrelation() {
        return new SqmCorrelatedMapJoin(this);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType) {
        return this.treatAs((Class)treatJavaType, (String)null);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget) {
        return this.treatAs((EntityDomainType)treatTarget, (String)null);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType, String alias) {
        return this.treatAs((Class)treatJavaType, alias, false);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        return this.treatAs((EntityDomainType)treatTarget, alias, false);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType, String alias, boolean fetch) {
        ManagedType treatTarget = this.nodeBuilder().getDomainModel().managedType(treatJavaType);
        SqmTreatedMapJoin treat = (SqmTreatedMapJoin)this.findTreat(treatTarget, alias);
        if (treat == null) {
            if (treatTarget instanceof TreatableDomainType) {
                return this.addTreat(new SqmTreatedMapJoin(this, (TreatableDomainType)treatTarget, alias, fetch));
            }
            throw new IllegalArgumentException("Not a treatable type: " + treatJavaType.getName());
        }
        return treat;
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetch) {
        SqmTreatedMapJoin treat = (SqmTreatedMapJoin)this.findTreat(treatTarget, alias);
        if (treat == null) {
            return this.addTreat(new SqmTreatedMapJoin(this, treatTarget, alias, fetch));
        }
        return treat;
    }

    @Override
    public SqmMapJoin<O, K, V> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmMapJoin<O, K, V>(creationProcessingState.getPathRegistry().findFromByPath(this.getLhs().getNavigablePath()), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), (NodeBuilder)this.nodeBuilder());
    }
}

