/*
 * Decompiled with CFR 0.152.
 */
package platform.files;

import com.BlockDynasty.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;

public class Languages {
    private final String languagePath = "/languages";
    private String[] languagesFiles = new String[]{"EN.yaml", "ES.yaml", "RU.yaml", "ZH.yaml"};
    private Map<String, File> languageFileMap = new HashMap<String, File>();
    private static Map<String, Object> mensajes = new HashMap<String, Object>();
    private File langDirectory;
    private File rootDirectory;

    public Languages(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.langDirectory = new File(rootDirectory, "/languages");
        if (!this.langDirectory.exists()) {
            this.langDirectory.mkdirs();
        }
        this.copyMissingLanguageFiles();
        this.loadLanguagesFiles();
        this.loadMessages("EN");
    }

    private void createLanguagesDirectory() {
        try {
            if (!this.langDirectory.exists()) {
                this.langDirectory.mkdirs();
            }
            for (String langFile : this.languagesFiles) {
                File file = new File(this.langDirectory, langFile);
                if (file.exists()) continue;
                try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("languages/" + langFile);){
                    if (inputStream == null) {
                        throw new RuntimeException("Language resource not found: " + langFile);
                    }
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            this.loadLanguagesFiles();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create languages directory", e);
        }
    }

    private void copyMissingLanguageFiles() {
        try {
            for (String langFile : this.languagesFiles) {
                File file = new File(this.langDirectory, langFile);
                if (file.exists()) continue;
                try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("languages/" + langFile);){
                    if (inputStream == null) {
                        throw new RuntimeException("Language resource not found: " + langFile);
                    }
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy language files", e);
        }
    }

    private void loadLanguagesFiles() {
        File[] files = this.langDirectory.listFiles((dir, name) -> name.endsWith(".yaml") || name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                String langCode = fileName.substring(0, fileName.lastIndexOf(46)).toUpperCase();
                this.languageFileMap.put(langCode, file);
            }
        }
    }

    public void loadMessages(String langCode) {
        File langFile = this.languageFileMap.get(langCode = langCode.toUpperCase());
        if (langFile == null && (langFile = this.languageFileMap.get("EN")) == null) {
            throw new RuntimeException("No language files available");
        }
        try {
            Yaml yaml = new Yaml();
            mensajes = (Map)yaml.load(Files.newInputStream(langFile.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load language file: " + langFile.getName(), e);
        }
    }

    public <T> T get(String path, Class<T> type) {
        String[] parts = path.split("\\.");
        Map current = mensajes;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.containsKey(parts[i])) {
                return null;
            }
            current = (Map)current.get(parts[i]);
        }
        String lastPart = parts[parts.length - 1];
        if (!current.containsKey(lastPart)) {
            return null;
        }
        Object value = current.get(lastPart);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    public String getMessage(String key) {
        return this.get(key, String.class);
    }
}

