/*
 * Decompiled with CFR 0.152.
 */
package platform.listeners;

import BlockDynasty.Economy.aplication.useCase.account.CreateAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import lib.commands.abstractions.IEntityCommands;
import platform.listeners.IPlayerJoin;

public class PlayerJoinListener
implements IPlayerJoin {
    protected final CreateAccountUseCase createAccountUseCase;
    protected final SearchAccountUseCase searchAccountUseCase;
    protected final IAccountService accountService;

    public PlayerJoinListener(CreateAccountUseCase createAccountUseCase, SearchAccountUseCase searchAccountUseCase, IAccountService accountService) {
        this.createAccountUseCase = createAccountUseCase;
        this.searchAccountUseCase = searchAccountUseCase;
        this.accountService = accountService;
    }

    @Override
    public void loadOnlinePlayerAccount(IEntityCommands player) {
        Result<Account> result = this.searchAccountUseCase.getAccount(player.getUniqueId());
        if (result.isSuccess()) {
            Result<Void> resultChangeName = this.accountService.checkNameChange(result.getValue(), player.getName());
            if (!resultChangeName.isSuccess()) {
                player.kickPlayer("Error al cargar tu cuenta de econom\u00eda. Por favor, vuelve a ingresar o contacta a un administrador.");
                return;
            }
            this.accountService.addAccountToOnline(result.getValue());
            return;
        }
        Result<Account> creationResult = this.createAccountUseCase.execute(player.getUniqueId(), player.getName());
        if (!creationResult.isSuccess()) {
            player.kickPlayer("Error al crear o cargar tu cuenta de econom\u00eda. Por favor, vuelve a ingresar o contacta a un administrador.");
        }
    }

    @Override
    public void loadOfflinePlayerAccount(IEntityCommands player) {
        Result<Account> result = this.searchAccountUseCase.getAccount(player.getName());
        if (result.isSuccess()) {
            Result<Void> resultChangeUuid = this.accountService.checkUuidChange(result.getValue(), player.getUniqueId());
            if (!resultChangeUuid.isSuccess()) {
                player.kickPlayer("Error al cargar tu cuenta de econom\u00eda. Por favor, vuelve a ingresar o contacta a un administrador.");
                return;
            }
            this.accountService.addAccountToOnline(result.getValue());
            return;
        }
        Result<Account> creationResult = this.createAccountUseCase.execute(player.getUniqueId(), player.getName());
        if (!creationResult.isSuccess()) {
            player.kickPlayer("Error al crear o cargar tu cuenta de econom\u00eda. Por favor, vuelve a ingresar o contacta a un administrador.");
        }
    }

    @Override
    public void offLoadPlayerAccount(IEntityCommands player) {
        this.accountService.removeAccountOnline(player.getUniqueId());
    }
}

