/*
 * Decompiled with CFR 0.152.
 */
package repository.Models;

import BlockDynasty.Economy.domain.entities.currency.Currency;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import repository.Models.BalanceDb;

@Entity
@Table(name="currency")
public class CurrencyDb {
    @Id
    @Column(name="uuid", unique=true)
    private String uuid;
    @Column(name="name_singular")
    private String singular;
    @Column(name="name_plural")
    private String plural;
    @Column(name="symbol")
    private String symbol;
    @Column(name="color")
    private String color;
    @Column(name="decimal_supported")
    private boolean decimalSupported;
    @Column(name="transferable")
    private boolean transferable;
    @Column(name="default_currency")
    private boolean defaultCurrency;
    @Column(name="default_balance")
    private BigDecimal defaultBalance;
    @Column(name="exchange_rate")
    private double exchangeRate;
    @OneToMany(mappedBy="currency", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BalanceDb> balances = new ArrayList<BalanceDb>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSingular() {
        return this.singular;
    }

    public void setSingular(String singular) {
        this.singular = singular;
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String plural) {
        this.plural = plural;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean isDecimalSupported() {
        return this.decimalSupported;
    }

    public void setDecimalSupported(boolean decimalSupported) {
        this.decimalSupported = decimalSupported;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    public boolean isDefaultCurrency() {
        return this.defaultCurrency;
    }

    public void setDefaultCurrency(boolean defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public BigDecimal getDefaultBalance() {
        return this.defaultBalance;
    }

    public void setDefaultBalance(BigDecimal defaultBalance) {
        this.defaultBalance = defaultBalance;
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public void update(Currency currency) {
        this.setSingular(currency.getSingular());
        this.setPlural(currency.getPlural());
        this.setColor(currency.getColor());
        this.setDecimalSupported(currency.isDecimalSupported());
        this.setTransferable(currency.isTransferable());
        this.setDefaultCurrency(currency.isDefaultCurrency());
        this.setDefaultBalance(currency.getDefaultBalance());
        this.setExchangeRate(currency.getExchangeRate());
        this.setSymbol(currency.getSymbol());
    }
}

