/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.aplication.useCase.AccountsUseCase;
import BlockDynasty.Economy.aplication.useCase.CurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.DepositUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.ExchangeUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.PayUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.SetBalanceUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.TradeCurrenciesUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.TransferFundsUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.WithdrawUseCase;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;

public class TransactionsUseCase {
    private final WithdrawUseCase withdrawUseCase;
    private final DepositUseCase depositUseCase;
    private final SetBalanceUseCase setBalanceUseCase;
    private final PayUseCase payUseCase;
    private final ExchangeUseCase exchangeUseCase;
    private final TradeCurrenciesUseCase tradeCurrenciesUseCase;
    private final TransferFundsUseCase transferFundsUseCase;

    public TransactionsUseCase(CurrencyUseCase currencyUseCase, AccountsUseCase accountsUseCase, IAccountService accountService, IRepository repository, Courier courier, Log economyLogger, EventManager eventManager) {
        this.withdrawUseCase = new WithdrawUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.depositUseCase = new DepositUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.setBalanceUseCase = new SetBalanceUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.payUseCase = new PayUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.exchangeUseCase = new ExchangeUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.tradeCurrenciesUseCase = new TradeCurrenciesUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
        this.transferFundsUseCase = new TransferFundsUseCase(currencyUseCase.getGetCurrencyUseCase(), accountsUseCase.getGetAccountsUseCase(), accountService, repository, courier, economyLogger, eventManager);
    }

    public WithdrawUseCase getWithdrawUseCase() {
        return this.withdrawUseCase;
    }

    public DepositUseCase getDepositUseCase() {
        return this.depositUseCase;
    }

    public SetBalanceUseCase getSetBalanceUseCase() {
        return this.setBalanceUseCase;
    }

    public PayUseCase getPayUseCase() {
        return this.payUseCase;
    }

    public ExchangeUseCase getExchangeUseCase() {
        return this.exchangeUseCase;
    }

    public TradeCurrenciesUseCase getTradeCurrenciesUseCase() {
        return this.tradeCurrenciesUseCase;
    }

    public TransferFundsUseCase getTransferFundsUseCase() {
        return this.transferFundsUseCase;
    }
}

