/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.GUI.adapters;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lib.gui.components.Materials;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;

public class MaterialAdapter {
    private static final Map<Materials, ItemType> MATERIAL_MAP = new HashMap<Materials, ItemType>();
    private static final ItemType FALLBACK = (ItemType)ItemTypes.STONE.get();

    public static void applyItemMeta(ItemStack item, String displayName, List<String> lore) {
        if (displayName != null) {
            if (item.type().equals(ItemTypes.PLAYER_HEAD.get())) {
                Optional optional = Sponge.server().player(displayName);
                optional.ifPresent(serverPlayer -> item.offer(Keys.GAME_PROFILE, (Object)serverPlayer.profile()));
            }
            item.offer(Keys.CUSTOM_NAME, (Object)MiniMessage.miniMessage().deserialize((Object)displayName));
        }
        if (lore != null) {
            List loreComponents = lore.stream().map(m -> MiniMessage.miniMessage().deserialize(m)).collect(Collectors.toList());
            item.offer(Keys.LORE, loreComponents);
        }
    }

    public static ItemType toItemType(Materials material) {
        return MATERIAL_MAP.getOrDefault((Object)material, FALLBACK);
    }

    static {
        for (Materials material : Materials.values()) {
            try {
                Field field = ItemTypes.class.getField(material.name());
                Object supplier = field.get(null);
                ItemType itemType = (ItemType)supplier.getClass().getMethod("get", new Class[0]).invoke(supplier, new Object[0]);
                MATERIAL_MAP.put(material, itemType);
            }
            catch (Exception e) {
                MATERIAL_MAP.put(material, FALLBACK);
            }
        }
    }
}

