/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.GUI.adapters;

import BlockDynasty.SpongePlugin;
import java.util.function.Function;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import net.kyori.adventure.text.TextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.ExecuteCommandEvent;
import org.spongepowered.api.event.message.PlayerChatEvent;

public class TextInput
implements ITextInput {
    @Override
    public void open(IEntityGUI owner, String title, String initialText, Function<String, String> function) {
        owner.sendMessage("[" + title + "] " + initialText);
        owner.sendMessage("Type your response in chat. Type 'cancel' to cancel.");
        owner.closeInventory();
        ChatInputListener listener = new ChatInputListener(null, owner, title, function);
        Sponge.eventManager().registerListeners(SpongePlugin.getPlugin(), (Object)listener);
    }

    @Override
    public void open(IGUI parent, IEntityGUI owner, String title, String initialText, Function<String, String> function) {
        owner.sendMessage("[" + title + "] " + initialText);
        owner.sendMessage("Type your response in chat. Type 'cancel' to cancel. Type 'back' to go back.");
        owner.closeInventory();
        ChatInputListener listener = new ChatInputListener(parent, owner, title, function);
        Sponge.eventManager().registerListeners(SpongePlugin.getPlugin(), (Object)listener);
    }

    public static class ChatInputListener {
        private final IGUI parent;
        private final IEntityGUI owner;
        private final String title;
        private final Function<String, String> function;

        public ChatInputListener(IGUI parent, IEntityGUI owner, String title, Function<String, String> function) {
            this.owner = owner;
            this.title = title;
            this.function = function;
            this.parent = parent;
        }

        @Listener(order=Order.EARLY)
        public void onChat(PlayerChatEvent.Submit event) {
            if (!(event.cause().root() instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)event.cause().root();
            if (!player.uniqueId().equals(this.owner.getUniqueId())) {
                return;
            }
            event.setCancelled(true);
            TextComponent component = (TextComponent)event.message();
            String input = component.content();
            if (input.equalsIgnoreCase("cancel")) {
                this.owner.sendMessage("Operation cancelled.");
                Sponge.eventManager().unregisterListeners((Object)this);
                return;
            }
            if (this.parent != null && input.equalsIgnoreCase("back")) {
                this.parent.open();
                Sponge.eventManager().unregisterListeners((Object)this);
                return;
            }
            String response = this.function.apply(input);
            if (response == null) {
                Sponge.eventManager().unregisterListeners((Object)this);
                return;
            }
            this.owner.sendMessage("[" + this.title + "] " + response);
            Sponge.eventManager().unregisterListeners((Object)this);
        }

        @Listener(order=Order.EARLY)
        public void onCommand(ExecuteCommandEvent.Pre event) {
            Sponge.eventManager().unregisterListeners((Object)this);
        }
    }
}

