/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.abstractions;

import BlockDynasty.SpongePlugin;
import BlockDynasty.adapters.GUI.adapters.InventoryAdapter;
import BlockDynasty.adapters.GUI.adapters.ItemStackAdapter;
import BlockDynasty.adapters.GUI.adapters.MaterialAdapter;
import BlockDynasty.adapters.abstractions.EntityPlayerAdapter;
import BlockDynasty.adapters.scheduler.Scheduler;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lib.abstractions.IPlayer;
import lib.abstractions.PlatformAdapter;
import lib.gui.components.IInventory;
import lib.gui.components.IItemStack;
import lib.gui.components.Materials;
import lib.scheduler.IScheduler;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.ContainerTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataChannel;
import org.spongepowered.plugin.PluginContainer;

public class SpongeAdapter
implements PlatformAdapter {
    PluginContainer pluginContainer = SpongePlugin.getPlugin();
    RawDataChannel channel = SpongePlugin.getChannel();

    @Override
    public IPlayer getPlayer(String name) {
        return Sponge.server().player(name).map(EntityPlayerAdapter::of).orElse(null);
    }

    @Override
    public IPlayer getPlayerByUUID(UUID uuid) {
        return Sponge.server().player(uuid).map(EntityPlayerAdapter::of).orElse(null);
    }

    @Override
    public List<IPlayer> getOnlinePlayers() {
        return Sponge.server().onlinePlayers().stream().map(EntityPlayerAdapter::of).collect(Collectors.toList());
    }

    @Override
    public void dispatchCommand(String command) throws Exception {
        Sponge.server().commandManager().process(command);
    }

    @Override
    public void sendPluginMessage(String channel, byte[] message) {
        Collection players = Sponge.server().onlinePlayers();
        ServerPlayer player = players.stream().findFirst().orElse(null);
        if (player != null) {
            RawPlayDataChannel playChannel = SpongePlugin.getChannel().play();
            playChannel.sendTo(player, buf -> buf.writeBytes(message));
        }
    }

    @Override
    public IScheduler getScheduler() {
        return new Scheduler();
    }

    @Override
    public File getDataFolder() {
        return SpongePlugin.configPath.toFile();
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public boolean hasSupportAdventureText() {
        return true;
    }

    @Override
    public IItemStack createItemStack(Materials material) {
        ItemStack itemStack = ItemStack.of((ItemType)MaterialAdapter.toItemType(material));
        return new ItemStackAdapter(itemStack);
    }

    @Override
    public IInventory createInventory(String title, int rows) {
        ViewableInventory.Custom viewableInventory = ViewableInventory.builder().type(this.getTypeFromRows(rows)).completeStructure().plugin(this.pluginContainer).build();
        return new InventoryAdapter((ViewableInventory)viewableInventory);
    }

    private ContainerType getTypeFromRows(int rows) {
        switch (rows) {
            case 1: {
                return (ContainerType)ContainerTypes.GENERIC_9X1.get();
            }
            case 2: {
                return (ContainerType)ContainerTypes.GENERIC_9X2.get();
            }
            case 3: {
                return (ContainerType)ContainerTypes.GENERIC_9X3.get();
            }
            case 4: {
                return (ContainerType)ContainerTypes.GENERIC_9X4.get();
            }
            case 5: {
                return (ContainerType)ContainerTypes.GENERIC_9X5.get();
            }
            case 6: {
                return (ContainerType)ContainerTypes.GENERIC_9X6.get();
            }
        }
        throw new IllegalArgumentException("Invalid number of rows: " + rows);
    }
}

