/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.commands;

import BlockDynasty.adapters.abstractions.EntityConsoleAdapter;
import BlockDynasty.adapters.abstractions.EntityPlayerAdapter;
import java.util.ArrayList;
import lib.commands.abstractions.Command;
import lib.commands.abstractions.IEntityCommands;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class CommandAdapter
implements CommandExecutor {
    private final Command command;
    public static Parameter.Value<String> ARGS = Parameter.remainingJoinedStrings().key("args").optional().build();

    public CommandAdapter(Command command) {
        this.command = command;
    }

    public CommandResult execute(CommandContext context) throws CommandException {
        IEntityCommands sender = context.cause().root() instanceof ServerPlayer ? EntityPlayerAdapter.of((ServerPlayer)context.cause().root()) : EntityConsoleAdapter.of(context.cause().audience());
        ArrayList<String> argList = new ArrayList<String>();
        if (this.command.getArgs() != null && !this.command.getArgs().isEmpty()) {
            for (String argName : this.command.getArgs()) {
                context.one(Parameter.string().key(argName).build()).ifPresent(argList::add);
            }
            String rawArgs = context.one(ARGS).orElse("");
            if (!rawArgs.isEmpty()) {
                String[] parts;
                for (String part : parts = rawArgs.split(" ")) {
                    argList.add(part);
                }
            }
        }
        try {
            this.command.execute(sender, argList.toArray(new String[0]));
            return CommandResult.success();
        }
        catch (Exception e) {
            throw new CommandException((Component)Component.text((String)e.getMessage()));
        }
    }
}

