/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.spongeEconomyApi;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.adapters.spongeEconomyApi.CurrencyAdapter;
import BlockDynasty.adapters.spongeEconomyApi.MultiCurrencyService;
import BlockDynasty.adapters.spongeEconomyApi.UniqueAccountAdapter;
import api.IApi;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.spongepowered.api.service.economy.account.AccountDeletionResultType;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.account.VirtualAccount;

public class EconomyServiceAdapter
implements MultiCurrencyService {
    private IApi api;

    public EconomyServiceAdapter(IApi api) {
        this.api = api;
    }

    public org.spongepowered.api.service.economy.Currency defaultCurrency() {
        return new CurrencyAdapter(this.api.getDefaultCurrency());
    }

    public boolean hasAccount(UUID uuid) {
        return this.api.existAccount(uuid);
    }

    public boolean hasAccount(String identifier) {
        return this.api.existAccount(identifier);
    }

    public Optional<UniqueAccount> findOrCreateAccount(UUID uuid) {
        Account response = this.api.getAccount(uuid);
        if (response != null) {
            return Optional.of(new UniqueAccountAdapter(response, this.api));
        }
        return Optional.empty();
    }

    public Optional<org.spongepowered.api.service.economy.account.Account> findOrCreateAccount(String identifier) {
        Account response = this.api.getAccount(identifier);
        if (response != null) {
            return Optional.of(new UniqueAccountAdapter(response, this.api));
        }
        return Optional.empty();
    }

    public Stream<UniqueAccount> streamUniqueAccounts() {
        return Stream.empty();
    }

    public Collection<UniqueAccount> uniqueAccounts() {
        return List.of();
    }

    public Stream<VirtualAccount> streamVirtualAccounts() {
        return Stream.empty();
    }

    public Collection<VirtualAccount> virtualAccounts() {
        return List.of();
    }

    public AccountDeletionResultType deleteAccount(UUID uuid) {
        return null;
    }

    public AccountDeletionResultType deleteAccount(String identifier) {
        return null;
    }

    @Override
    public List<org.spongepowered.api.service.economy.Currency> getCurrencies() {
        return List.of();
    }

    @Override
    public Optional<org.spongepowered.api.service.economy.Currency> getCurrency(String currencyName) {
        Currency response = this.api.getCurrency(currencyName);
        if (response != null) {
            return Optional.of(new CurrencyAdapter(response));
        }
        return Optional.empty();
    }
}

