/*
 * Decompiled with CFR 0.152.
 */
package files.logs;

import BlockDynasty.Economy.domain.services.log.Log;
import Main.Console;
import files.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lib.scheduler.ContextualTask;
import lib.scheduler.IScheduler;
import utils.UtilTime;

public abstract class AbstractLogger
implements Log {
    private static boolean firstInstanceCreated = false;
    private final File folder;
    private final File latest;
    private final Set<String> toAdd;
    private volatile boolean zipping;
    private final IScheduler scheduler;

    public AbstractLogger(Configuration config, IScheduler scheduler) {
        this.scheduler = scheduler;
        this.folder = new File(config.getLogsPath());
        this.latest = new File(this.folder, "LATEST.log");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        if (!this.latest.exists()) {
            try {
                this.latest.createNewFile();
            }
            catch (IOException ex) {
                Console.logError(ex.getMessage());
            }
        }
        this.toAdd = new HashSet<String>();
        this.zipping = false;
        if (!firstInstanceCreated) {
            this.zipAndReplace();
            firstInstanceCreated = true;
        }
    }

    @Override
    public void log(String message) {
        try {
            StringBuilder builder = new StringBuilder();
            this.appendDate(builder);
            builder.append(this.getName());
            builder.append(message);
            this.writeToFile(builder.toString());
        }
        catch (IOException ex) {
            Console.logError(ex.getMessage());
        }
    }

    public abstract String getName();

    @Override
    public void save() {
        this.zipAndReplace();
    }

    private void zipAndReplace() {
        this.zipping = true;
        this.scheduler.runAsync(ContextualTask.build(() -> {
            try {
                int length;
                String date = UtilTime.date();
                date = date.replace("/", "-");
                File zFile = new File(this.folder, date + ".zip");
                int link = 1;
                while (zFile.exists()) {
                    zFile = new File(this.folder, date + "[" + link + "].zip");
                    ++link;
                }
                FileOutputStream fos = new FileOutputStream(zFile);
                ZipOutputStream zipOut = new ZipOutputStream(fos);
                FileInputStream fis = new FileInputStream(this.latest);
                ZipEntry zipEntry = new ZipEntry(date + ".log");
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                zipOut.close();
                fis.close();
                fos.close();
                this.latest.delete();
                this.latest.createNewFile();
                PrintWriter writer = new PrintWriter(new FileWriter(this.latest, true));
                this.toAdd.forEach(writer::println);
                this.toAdd.clear();
                writer.close();
                this.zipping = false;
            }
            catch (Exception e) {
                Console.logError(e.getMessage());
            }
        }));
    }

    private void appendDate(StringBuilder builder) {
        builder.append('[').append(this.getDateAndTime()).append(']').append(' ');
    }

    private void writeToFile(String string) throws IOException {
        if (this.zipping) {
            this.toAdd.add(string);
            return;
        }
        PrintWriter writer = new PrintWriter(new FileWriter(this.latest, true));
        writer.println(string);
        writer.close();
    }

    private String getDateAndTime() {
        return UtilTime.now();
    }
}

